/**
 * MSH2004InvKinWalkingEngine
 *
 * @author Thomas Kindler <thomas.kindler@gmx.de>
 */
#include "MSH2004InvKinWalkingEngine.h"
#include "Platform/GTAssert.h"
#include "Tools/Location.h"
#include "Tools/Debugging/Debugging.h"

/**
 * Construct a new MSH Walking engine
 *
 * @param  pEngine  InvKinWalkingEngine to use.
 *
 */
MSH2004InvKinWalkingEngine::MSH2004InvKinWalkingEngine(
  InvKinWalkingEngine  *pEngine
)
  : WalkingEngine(*pEngine), pEngine(pEngine)
{
}


/**
 * Calculates the next joint data set. 
 *
 * @param   jointData      stores calculated frame  
 * @param   walkRequest  the current motion request  
 *
 * @return  true if next set should be calculated by WalkingEngine,
 *          false if change to other module can occur 
 * 
 */
bool MSH2004InvKinWalkingEngine::executeParameterized(
        JointData      &jointData,
  const WalkRequest  &walkRequest,
  double positionInWalkingCycle
)
{ 
  char *paramType = "";

  if (walkRequest.walkParams.translation.x  > -50 ||
      fabs(walkRequest.walkParams.rotation) >   2  ) {
    paramType = "fast";
    pEngine->setParameters(&forward);
  } else {
    paramType = "conservative";
    pEngine->setParameters(&backward);
  }
  
  INFO( sendWalkingEngineInfo, idText, text,
    "walkParams: "
    "x = " << walkRequest.walkParams.translation.x << ", " <<
    "y = " << walkRequest.walkParams.translation.y << ", " <<
    "r = " << walkRequest.walkParams.rotation      << " -> " <<
    "using " << paramType << " parameters."
  );
 
  bool   result = pEngine->executeParameterized(jointData, walkRequest, positionInWalkingCycle);
  return result;
}


bool MSH2004InvKinWalkingEngine::handleMessage(InMessage& message)
{
  return pEngine->handleMessage(message);
}

