/**
* @file InvKinWalkingParameterSets.h
* 
* This file contains different 
* parameter sets for the
* InvKinWalkingEngine
*
* @author Max Risler
*/

/**
 *      \   ^__^
 *       \  (oo)\_______
 *          (__)\       )\/\*
 *              ||----w |
 *              ||     ||
 */

#ifndef __InvKinWalkingParametersSets_h_
#define __InvKinWalkingParametersSets_h_

#include "InvKinWalkingParameters.h"

/**
* @class UpsideDownWalkingParameters
* Parameters for InvKinWalkingEngine that let robot walk upside down.
* Completely useless but looks funny
* @author Max Risler
*/
class UpsideDownWalkingParameters : public InvKinWalkingParameters
{
public:
  UpsideDownWalkingParameters() : InvKinWalkingParameters(
    "UpsideDown",
    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX
    //old kinematics:-95, 90,  50,
    -103.2, 97.4, 55.8,
    //hindHeight,hindWidth,hindCenterX
    //old kinematics:-95, 90, -50,
    -104.4, 99.4, -56.6,
    //foreFootLift,hindFootLift
    -20, -20,
    //foreFootTilt,hindFootTilt
    //old kinematics:0, 0,
    0.34, 0.11,
    //legSpeedFactorX/Y/R
    1.01, 1.5, 1.0,
    //maxStepSizeX/Y
    //old kinematics: 43.4, 20.0,
    40, 30,
    //maxSpeedChangeX/Y,maxRotationChange
    100.0, 100.0, 1.0,
    //counterRotation
    //old kinematics: 0.1,
    0.14,
    //stepLen
    120, 
    //groundPhaseF,LiftPhaseF,LowerPhaseF
    0.5, 0.06, 0.06,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.5, 0.06, 0.06,
    //legPhase
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset
    0, 0, 0, 0,
    //leaveAnytime
    0,
    //headTilt
    -1500000,
    //headPan
    0,
    //headRoll
    0,
    //mouth
    0
    )
  {}
};


/**
* @class TurnKickWalkingParameters
* Parameters for InvKinWalkingEngine
* @author Matthias Jngel
*/
class TurnKickWalkingParameters : public InvKinWalkingParameters
{
public:
  TurnKickWalkingParameters() : InvKinWalkingParameters(
    "TurnKick",
    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX
    76.5308, 78.1, 85.0,
    //hindHeight,hindWidth,hindCenterX
    108.72, 76.95, -49.56, 
    //foreFootLift,hindFootLift
    5, 24, 
    //foreFootTilt,hindFootTilt
    -0.25, 0.0450392,
    //legSpeedFactorX/Y/R
    1.1, 1.13782, 1.19384,
    //maxStepSizeX/Y
    38, 43.0719,
    //maxSpeedChangeX/Y,maxRotationChange
    100.0, 100.0, 1.0,
    //counterRotation
    0.055,
    //stepLen
    77, 
    //groundPhaseF,LiftPhaseF,LowerPhaseF
    0.5, 0.06, 0.06,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.5, 0.06, 0.06,
    //legPhase
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset
    0.800923, 0, 0, 0,
    //leaveAnytime
    1
    )
  {
  }
};


/**
 * @class   MSH2004WalkingParameters
 * @author  Thomas Kindler <thomas.kindler@gmx.de>
 *
 * 34cm/s walk, 10.03.2004
 */
class MSH2004WalkingParameters : public InvKinWalkingParameters
{
public:
  MSH2004WalkingParameters() : InvKinWalkingParameters(
    "MSH2004",

    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX
    77.5836, 80.2702, 50.3536,
    //hindHeight,hindWidth,hindCenterX
    105.174, 81.5432, -52.0932,
    //foreFootLift,hindFootLift
    5.24393, 24.5014,
    //foreFootTilt,hindFootTilt
    -0.251997, 0.0161507,
    //legSpeedFactorX/Y/R  
    1.16278, 1.10182, 1.14494,
    //maxStepSizeX/Y  
    37.323, 43.6967,
    //maxSpeedChangeX/Y,maxRotationChange  
    100, 100, 1,
    //counterRotation  
    0.055,
    //stepLen  
    64,
    //groundPhaseF,LiftPhaseF,LowerPhaseF  
    0.491957, 0.0833278, 0.0664729,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.49005, 0.089776, 0.0767162,
    //legPhase  
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset  
    0.800923, 0, 0, 0,
    //leaveAnytime
    1
  ) { }
};

/**
 * @class   MSH2004BackwardsWalkingParameters
 * @author  Thomas Kindler <thomas.kindler@gmx.de>
 * @author  Arthur Cesar
 * 21 cm/s 19.03.2003
 */

class MSH2004BackwardsWalkingParameters : public InvKinWalkingParameters
{
public:
  MSH2004BackwardsWalkingParameters() : InvKinWalkingParameters(
    "MSH2004Backwards",

    // 28,24 cm
    //footMode
    0, 
    //foreHeight,foreWidth,foreCenterX
    88.5057, 79.127, 43.2139, 
    //hindHeight,hindWidth,hindCenterX
    101.905, 77.6874, -49.6692, 
    //foreFootLift,hindFootLift  
    9.76973, 28.5799,
    //foreFootTilt,hindFootTilt  
    -0.0724927, 0.0922574, 
    //legSpeedFactorX/Y/R
    1.20455, 0.843727, 1.44822, 
    //maxStepSizeX/Y  
    34.8207, 38.8411,
    //maxSpeedChangeX/Y,maxRotationChange
    100, 100, 1,
    //counterRotation  
    0.06, 
    //stepLen  
    61,
    //groundPhaseF,LiftPhaseF,LowerPhaseF  
    0.461105, 0.0361205, 0.0391534,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.508829, 0.0532571, 0.0469326,
    //legPhase  
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset  
    0, 0, 0.0337565,
    //leaveAnytime
    1
  ) { }
};


/**
 * @class   TurnWithBallWalkingParameters
 * @author  Uwe Dffert
 *
 * with only minimal changed to TurnWithBallWalkingParameters
 */
class TurnWithBallWalkingParameters : public InvKinWalkingParameters
{
public:
  TurnWithBallWalkingParameters() : InvKinWalkingParameters(
    "TurnWithBall",
    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX
    77.5836, 80.2702, 80.3536,
    //hindHeight,hindWidth,hindCenterX
    115.174, 81.5432, -52.0932,
    //foreFootLift,hindFootLift
    5.24393, 24.5014,
    //foreFootTilt,hindFootTilt
    -0.251997, 0.0161507,
    //legSpeedFactorX/Y/R  
    1.16278, 1.10182, 1.14494,
    //maxStepSizeX/Y  
    37.323, 43.6967,
    //maxSpeedChangeX/Y,maxRotationChange  
    100, 100, 1,
    //counterRotation  
    0.055,
    //stepLen  
    64,
    //groundPhaseF,LiftPhaseF,LowerPhaseF  
    0.491957, 0.0833278, 0.0664729,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.49005, 0.089776, 0.0767162,
    //legPhase  
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset  
    0.800923, 0, 0, 0,
    //leaveAnytime
    1
  ) { }
};

/**
* @class ERS7EvolveWalkingParameters
* Parameters for InvKinWalkingEngine to evolve better walking gates
* @author Uwe Dffert
*/
class ERS7EvolveWalkingParameters : public InvKinWalkingParameters
{
public:
  ERS7EvolveWalkingParameters() : InvKinWalkingParameters(
    "ERS7Evolve",
    //footMode
    0, //rectangle
    //foreHeight,foreWidth,foreCenterX
    76.5308, 78.1, 53.6242,
    //hindHeight,hindWidth,hindCenterX
    108.72, 76.95, -49.56, 
    //foreFootLift,hindFootLift
    5, 24, 
    //foreFootTilt,hindFootTilt
    -0.25, 0.0450392,
    //legSpeedFactorX/Y/R
    1.1, 1.13782, 1.19384,
    //maxStepSizeX/Y
    38, 43.0719,
    //maxSpeedChangeX/Y,maxRotationChange
    100.0, 100.0, 1.0,
    //counterRotation
    0.055,
    //stepLen
    77, 
    //groundPhaseF,LiftPhaseF,LowerPhaseF
    0.5, 0.06, 0.06,
    //groundPhaseH,LiftPhaseH,LowerPhaseH
    0.5, 0.06, 0.06,
    //legPhase
    0, 0.5, 0.5, 0,
    //bodyShiftX/Y, bodyShiftOffset, bodyTiltOffset
    0.800923, 0, 0, 0,
    //leaveAnytime
    1
    )
  {}
};

#endif// __InvKinWalkingParameterSets_h_

/*
 * Change log :
 * 
 * $Log: InvKinWalkingParameterSets.h,v $
 * Revision 1.4  2004/06/14 16:53:45  juengel
 * Removed some WalkingEngineParameterSets.
 *
 * Revision 1.3  2004/06/04 16:36:43  juengel
 * Added walkType turn-kick
 *
 * Revision 1.2  2004/06/04 13:46:45  dueffert
 * new more MSH2004 like turnwithball added
 *
 * Revision 1.1.1.1  2004/05/22 17:22:52  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.18  2004/04/08 15:33:06  wachter
 * GT04 checkin of Microsoft-Hellounds
 *
 * Revision 1.17  2004/04/07 12:29:00  risler
 * ddd checkin after go04 - first part
 *
 * Revision 1.6  2004/04/02 23:44:40  dthomas
 * added new invKinParams for turn with ball
 * integrated into rotate-around-ball
 * combined with updated catch-ball head-control-mode
 *
 * Revision 1.5  2004/03/31 11:54:18  dthomas
 * minor reduce sideward speed of dddErs7fast
 *
 * Revision 1.4  2004/03/31 10:08:07  dthomas
 * added new parameterset for ers7 based on jolly pochie
 *
 * Revision 1.3  2004/03/29 21:13:42  dthomas
 * small improvements in direction and correct counterRotation
 *
 * Revision 1.2  2004/03/29 10:06:24  dthomas
 * added new ers7 walking engine parameters
 *
 * Revision 1.1.1.1  2004/03/29 08:28:46  Administrator
 * initial transfer from tamara
 *
 * Revision 1.16  2004/03/29 16:26:42  dueffert
 * sign bug fixed
 *
 * Revision 1.15  2004/03/29 15:24:25  dueffert
 * new turn parameterset
 *
 * Revision 1.14  2004/03/26 09:20:29  dueffert
 * ::ERS7 beautified
 *
 * Revision 1.13  2004/03/17 01:10:51  cesarz
 * added MSH2004TurnWithBallWalkingParameters
 *
 * Revision 1.12  2004/03/15 21:23:50  kindler
 * - changed name of MSH parameters to "MSH2004"
 *
 * Revision 1.11  2004/03/10 17:45:21  kindler
 * - Added MSH2004 InvKinWalkingEngine parameter set.
 *
 * Revision 1.10  2004/03/09 15:37:03  dueffert
 * doxygen bug fixed; beautified
 *
 * Revision 1.9  2004/03/04 18:20:03  juengel
 * Added ERS7TurnWithBallWalkingParameters.
 *
 * Revision 1.8  2004/03/02 10:10:54  mellmann
 * new parameterset for ERS7
 *
 * Revision 1.7  2004/02/16 17:56:32  dueffert
 * InvKin engine and parameters separated
 *
 */
