/**
* @file ATH2004TeamBallLocator.cpp
* 
* Implementation of class TeamBallLocator
*
* @author <a href="mailto:roefer@tzi.de">Thomas Rfer</a>
* @author Martin Ltzsch
*/

#include "ATH2004TeamBallLocator.h"
#include "Platform/SystemCall.h"

ATH2004TeamBallLocator::ATH2004TeamBallLocator(const TeamBallLocatorInterfaces& interfaces)
: TeamBallLocator(interfaces)
{
}

void ATH2004TeamBallLocator::execute()
{
  double validityMax = 0;
  int bestIndex = -1;

  for(int i = 0; i < teamMessageCollection.numberOfTeamMessages; ++i)
  {
    // get the time until the ball was seen consecutively in own time
    unsigned long timeUntilSeenConsecutively
      = teamMessageCollection[i]
      .getTimeInOwnTime(teamMessageCollection[i].seenBallPosition.timeWhenLastSeen);

    if(SystemCall::getTimeSince(timeUntilSeenConsecutively) < 2000)
    {
      // The ball was seen consecutively by the other robot in the last 2 seconds

      double v = teamMessageCollection[i].robotPose.getValidity();

      if(v > validityMax)
      {
        // take the ball of the robot with the highest validity of the robot's pose
        validityMax = v;
        bestIndex = i;
      }
    }
  }

  if(bestIndex >= 0)
  {
    // copy the seen ball position of the best other robot to
    // the communicated ball position
    communicatedBallPosition.x = teamMessageCollection[bestIndex].seenBallPosition.x;
    communicatedBallPosition.y = teamMessageCollection[bestIndex].seenBallPosition.y;
    communicatedBallPosition.timeWhenLastObserved
      = teamMessageCollection[bestIndex].getTimeInOwnTime
      (teamMessageCollection[bestIndex].seenBallPosition.timeUntilSeenConsecutively);
  }
}


/*
* Change log :
* 
* $Log: ATH2004TeamBallLocator.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:22:25  cvsadm
* created new repository GT2004_WM
*
* Revision 1.1  2004/04/05 17:56:47  loetzsch
* merged the local German Open CVS of the aibo team humboldt with the tamara CVS
*
* Revision 1.2  2004/04/01 22:46:55  loetzsch
* experiments
*
* Revision 1.1.1.1  2004/03/31 11:16:50  loetzsch
* created ATH repository for german open 2004
*/
