/**
* @file DefaultSpecialVision.h
* 
* Definition of class DefaultSpecialVision
*
* @author <A href=mailto:juengel@informatik.hu-berlin.de>Matthias Juengel</A>
*/

#ifndef __DefaultSpecialVision_h_
#define __DefaultSpecialVision_h_

#include "SpecialVision.h"
#include "BarCodeReader.h"
#include "AutoShutter.h"
#include "ChallengeSpecialVision.h"
#include "Representations/Perception/ColorTable.h"

/** The default SpecialVision module */
class DefaultSpecialVision : public SpecialVision
{
public:
  /** Constructor 
  * @param interfaces The interfaces of the SpecialVision module */
  DefaultSpecialVision(const SpecialVisionInterfaces& interfaces);

  /** Executes the module */
  virtual void execute();
private:
  BarCodeReader barCodeReader;
  AutoShutter autoShutter;
  ChallengeSpecialVision challengeSpecialVision;
};

#endif// __DefaultSpecialVision_h_

/*
* Change log :
* 
* $Log: DefaultSpecialVision.h,v $
* Revision 1.3  2004/06/28 12:01:34  kerdels
* added a Special Vision AutoShutter...
*
* Revision 1.2  2004/06/28 11:54:56  wachter
* Added Special-Vision classes for Challenge
*
* Revision 1.1.1.1  2004/05/22 17:22:25  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2004/03/08 02:11:53  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/06 14:10:13  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 15:27:48  juengel
* Renamed DataTypes to representations.
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2003/02/18 21:29:17  osterhues
* Changed all instances of ColorTable64 to new base class ColorTable
*
* Revision 1.4  2003/01/29 10:37:21  juengel
* Added BarCodeReader.
*
* Revision 1.3  2002/11/19 15:43:03  dueffert
* doxygen comments corrected
*
* Revision 1.2  2002/09/17 23:55:22  loetzsch
* - unraveled several datatypes
* - changed the WATCH macro
* - completed the process restructuring
*
* Revision 1.1  2002/09/10 15:36:16  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.3  2002/06/02 23:21:09  roefer
* Single color table and progress in LinesSelfLocator
*
* Revision 1.2  2002/05/17 11:51:48  brunn
* first experimental version of the barPerceptor
*
* Revision 1.1  2002/05/10 17:40:26  juengel
* Added SpecialVision and SpecialPercept.
*
*
*/
