/**
* @file DefaultSpecialVision.cpp
* 
* Implementation of class DefaultSpecialVision
*
* @author <A href=mailto:juengel@informatik.hu-berlin.de>Matthias Juengel</A>
*/

#include "DefaultSpecialVision.h"

DefaultSpecialVision::DefaultSpecialVision(const SpecialVisionInterfaces& interfaces)
: SpecialVision(interfaces), barCodeReader(interfaces), autoShutter(interfaces), challengeSpecialVision(interfaces)
{
}

void DefaultSpecialVision::execute()
{

 
 switch(specialVisionRequest.specialVisionRequest)
  {
  case SpecialVisionRequest::none:
    break;
  case SpecialVisionRequest::barCode:
    barCodeReader.execute();
    break;
  case SpecialVisionRequest::autoShutter:
    autoShutter.execute();
    break;
  case SpecialVisionRequest::challengeGetOrientation:
  case SpecialVisionRequest::challengeLearnOrientation:
  case SpecialVisionRequest::challengeFindOrientation:
    challengeSpecialVision.execute();
    break;
  default:
    break;
  }

}

/*
* Change log :
* 
* $Log: DefaultSpecialVision.cpp,v $
* Revision 1.5  2004/07/01 18:42:08  hamerla
* SLAM challenge find Orientation
*
* Revision 1.4  2004/06/28 18:43:31  wachter
* - bugfixes
*
* Revision 1.3  2004/06/28 12:01:34  kerdels
* added a Special Vision AutoShutter...
*
* Revision 1.2  2004/06/28 11:54:55  wachter
* Added Special-Vision classes for Challenge
*
* Revision 1.1.1.1  2004/05/22 17:22:25  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2004/03/08 02:11:53  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/06 14:10:13  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.4  2003/01/29 10:37:21  juengel
* Added BarCodeReader.
*
* Revision 1.3  2002/11/19 15:43:03  dueffert
* doxygen comments corrected
*
* Revision 1.2  2002/09/17 23:55:22  loetzsch
* - unraveled several datatypes
* - changed the WATCH macro
* - completed the process restructuring
*
* Revision 1.1  2002/09/10 15:36:16  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.7  2002/07/23 13:33:40  loetzsch
* new streaming classes
*
* removed many #include statements
*
* Revision 1.6  2002/06/28 10:26:19  roefer
* OUTPUT is possible in constructors
*
* Revision 1.5  2002/06/03 04:59:37  brunn
* BarPerceptor::execute can now be called since colortable is provided
*
* Revision 1.4  2002/06/02 23:21:09  roefer
* Single color table and progress in LinesSelfLocator
*
* Revision 1.3  2002/05/17 11:51:48  brunn
* first experimental version of the barPerceptor
*
* Revision 1.2  2002/05/15 10:46:22  brunn
* New Roles for Colaboration Challenge 2002
* Extended draft for bar-perception
*
* Revision 1.1  2002/05/10 17:40:26  juengel
* Added SpecialVision and SpecialPercept.
*
*/
