/**
* @file ChallengeSpecialVision.h
* 
* Definition of class ChallengeSpecialVision
* This class finds out the orientation of the robot for the "Almost-Slam-Challenge"
*
* @author Thomas Kindler
* @author Matthias Hlsbusch
* @author Michael Wachter
*/

#ifndef __ChallengeSpecialVision_h_
#define __ChallengeSpecialVision_h_

#include "SpecialVision.h"


#define NUMBEROFSECTORS 36

class ChallengeSectorData
{
public:
	int numPixels[numOfColors];
};


class ChallengeSpecialVision : public SpecialVision
{
public:
  /** Constructor 
  * @param interfaces The interfaces of the SpecialVision module */
  ChallengeSpecialVision(const SpecialVisionInterfaces& interfaces);

  /** Executes the module */
  virtual void execute();
  
private:
	void executeLearnOrientation();
	void executeFindOrientation();
	void executeGetOrientation();
  void executeReset();
	ChallengeSectorData countPixels(int x1,int x2,int y1,int y2);
	
private:
  void sort( double* a, const int number);
  double alngleDifDegree(double a, double b);
  double flagAngle[MAXLEARNFLAGS];
  double foundAngle[MAXLEARNFLAGS];
  int flagCount;
  int foundAngleCount;

private:
	ChallengeSectorData data[NUMBEROFSECTORS];

};

#endif// __BarCodeReader_h_

/*
* Change log :
* 
* $Log: ChallengeSpecialVision.h,v $
* Revision 1.3  2004/07/01 18:42:08  hamerla
* SLAM challenge find Orientation
*
* Revision 1.2  2004/06/28 16:02:37  wachter
* First lines of code for challenge-special-vision
*
* Revision 1.1  2004/06/28 11:54:55  wachter
* Added Special-Vision classes for Challenge
*
*
*/
