/**
* @file BarCodeReader.cpp
* 
* Implementation of class BarCodeReader
*
* @author <A href=mailto:goehring@informatik.hu-berlin.de>Daniel Ghring</A>
*/

#include "BarCodeReader.h"
#include "Tools/Debugging/DebugImages.h"
#include "Tools/Debugging/DebugDrawings.h"
#include "Representations/Perception/SensorData.h"




BarCodeReader::BarCodeReader(const SpecialVisionInterfaces& interfaces)
: SpecialVision(interfaces)
{
}

void BarCodeReader::execute()
{
  //image;


  /** Declaration */
  // brightness values

  int avg;    // average brightness,is it necessary ???
  int max;   // max. brightness
  int min;   // min. brightness
  int upperInt;   // white bar lower boundary y - channel
  int lowerInt;   // black bar upper boundary y - channel
  
  
  // scan position values
  
  int l1;         // scan line variable
  int start;  // current scan column variable
  int over;   // black to white border column variable
  int fin;    // white to black border column variable - first block position

  
  // barcode properties, which must fulfill certain comstraints
  
  //int whiteDist = 3; //minimal expected white pixels between two black bars
  //int whiteCount = 0; // counts the white pixels 
  int width = 0;    // current bar distance
  int widthref = 0; // previous bar cluster length (from old start to next start)
  double succRat = 1.1; //width ratio tolerance between two succeeding blocks   //Var ends


  // barcode calculated values 

  int barValue[9];  // bit value interpreted while scanning
  int value = -1;   // calculated code value - if scanning succeeded

  
  // flags

  int brk = 0;    // scan error flag


  // Tools: PSD sensor

//  double s = sensorData.data[SensorData::psd];


  
  /** Just for debugging */
  
  DECLARE_DEBUG_IMAGE(imageProcessorGradients); 
  INIT_DEBUG_IMAGE(imageProcessorGradients, image);

  ColorClassImage colIm;
  colorTable.generateColorClassImage(image,colIm);

  
    
  /** Scanbarcode starts */
  
  //OUTPUT(idText, text, "  LOS "); // 2 do: Channel check !!!

  

  for (l1 = 6; l1 < 144; l1 += 12) {

  /** Setting values */

  //reset brightness values  
  
  avg = 0;     // average brightness
  max = -1;    // max. brightness
  min = -1;    // min. brightness

  
  // scan position values

  start = 0;  // current scan column variable
  over = 0;   // black to white border column variable
  fin = 0;    // white to black border column variable - first block position

  
  // barcode properties, which must fulfill certain comstraints

  //whiteCount = 0;  // counts the white pixels 
  width = 0;    // current bar distance
  widthref = 0; // previous bar cluster length (from old start to next start)


  // barcode calculated values 

  {for (int a = 0; a < 9; a++) {
    barValue[a] = -1;
    }
  }
  
  value = -1;

  // Error flag 
  
  brk = 0;    // if error, then switched to 1


  /** Calculate the y-channel boundaries min, max and avg */

  { for (int x = 62; x < 82; x++) {   // take a sample from the middle of the scan line
      
      avg += image.image[l1][0][x];

     // OUTPUT(idText, text, "Number: "<<x<<"  Wert " << image.image[l1][0][x] ); 

      if ((max == -1) || (max < image.image[l1][0][x])) {
          max = image.image[l1][0][x];
      }

      if ((min == -1) || (min > image.image[l1][0][x])) {
          min = image.image[l1][0][x];
      }

    }
  }
    
  avg /= 20;

  // min, max and avg calculated
  
  
  // set the error flag if illumination is not sufficient
  
  if ((max - min) < 50) {
    brk = 1;
  }

  
  // calculate the white and respectively black intervall boundary values

  upperInt = min + (max-min)*2/3;    // white bar lower boundary y - channel
  lowerInt = min + (max-min)*1/3;    // black bar upper boundary y - channel
  

  // DEBUG
  //OUTPUT(idText, text, "  min Helligkeit " << min  );  
  //OUTPUT(idText, text, "  avg Helligkeit " << avg  );  
  //OUTPUT(idText, text, "  max Helligkeit " << max  );  

  

  
// scanning begins at leftmost position
  
// scan for pixel not belonging to the code sheet

  while (((start+5) < image.cameraInfo.resolutionWidth) &&
         ((image.image[l1][0][start  ] <= upperInt) ||
          (image.image[l1][0][start+1] <= upperInt) ||
          (image.image[l1][0][start+2] <= upperInt) ||
          (image.image[l1][0][start+3] <= upperInt) ||
          (image.image[l1][0][start+4] <= upperInt))) {
              start++;
          } 
  
// now at the beginning of the first white lane
  
 
// scan for pixel until reaching the first black bar
  
  while ((((start+1) < image.cameraInfo.resolutionWidth) && (image.image[l1][0][start] > upperInt))) {
              start++;
            }
 
  //whiteCount = 0;

  //OUTPUT(idText, text, "first black after " << start << " imw " << image.cameraInfo.resolutionWidth);
  

  

// found the black first bar


/** now loop eight times for the expected 8 code bars */
       
  
  for (int b = 0; b < 9; b++) {
        
      DEBUG_IMAGE_SET_PIXEL_GREEN(imageProcessorGradients, start, l1);  
      CIRCLE(sketch, start, l1, 4, 1, 1, Drawings::red);

      fin = start; // remember the start of the black line in 'fin'

      
      // measure the black line thickness

      while ((((start+1) < image.cameraInfo.resolutionWidth) && (image.image[l1][0][start  ] <= lowerInt)) ||
             (((start+2) < image.cameraInfo.resolutionWidth) && (image.image[l1][0][start+1] <= lowerInt)))     
      {   
          start++;
      }

      // remember the end of the black lane in 'over'
      
      over = start;


      // measure the white line thickness

      while (((start + 3) < image.cameraInfo.resolutionWidth) && (
                (image.image[l1][0][start  ] > upperInt) ||
                (image.image[l1][0][start+1] > upperInt) ||
                (image.image[l1][0][start+2] > upperInt)))
      { 
          start++;
      }

      
      // calculate the cluster thickness
      
      
      if (b == 8) 
      {
        width = over - fin;
        //whiteCount = 0;
      }
      else
      {
        width = start - fin;
        //whiteCount = 0;
      }
      
      // check if the cluster thickness is almost similar to the last cluster thickness

      if ((widthref == 0) || ((widthref <= width*succRat) && (widthref*succRat > width))) {
           widthref = width;
      }
      
      // if not - set error flag
      
      else {
           brk = 1;
           //OUTPUT(idText, text, "  Unequal border widths " << b+1 );

      }

      // calculate the cluster's bit value from the black/white ratio in the cluster

      if ((over - fin) < 0.40 * width)   
        {barValue[b] = 1;}    // we got a one

      else 
      if ((over - fin) > 0.60 * width)   
        {barValue[b] = 0;}    // we got a zero

      else
      {
        brk = 1;              // not a number - set error flag
      }

      //OUTPUT(idText, text, "  Bar Number " << b+1 << " at " << start << " value " << barValue[b]);

  }


  /** Checksum check*/
  
  if (((((barValue[0] + barValue[1] + barValue[2])%2)  == barValue[6]) ||
      (((barValue[3] + barValue[4] + barValue[5])%2)  == barValue[7])) && (brk == 0)  )
  {
    value = barValue[0]*32+barValue[1]*16+barValue[2]*8+barValue[3]*4+
            barValue[4]*2+barValue[5];

  // if CC passed -  calculate value

            //OUTPUT(idText, text, "  Value " << value  );  
            specialPercept.barCodeId = value;
  }  
  else
  {
            specialPercept.barCodeId = -1;
  // if not - set error flag and calculate nothing  
    
    //OUTPUT(idText, text, " Checksum error ");

    brk = 1;
  }
 
  
 if (!brk) {  
   
   /* if we got a value we can leave, otherwise make a further attempt in a
      new line  */
     break;
    }
  } 


  

  //OUTPUT(idText, text, "BarCodeReader::execute()");

  // DEBUG
  
  DEBUG_DRAWING_FINISHED(sketch);
  SEND_DEBUG_IMAGE(imageProcessorGradients);


}

/*
* Change log :
* 
* $Log: BarCodeReader.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:22:25  cvsadm
* created new repository GT2004_WM
*
* Revision 1.3  2004/03/08 02:11:53  roefer
* Interfaces should be const
*
* Revision 1.2  2003/12/15 11:46:13  juengel
* Introduced CameraInfo
*
* Revision 1.1  2003/10/06 14:10:13  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/09/26 15:27:48  juengel
* Renamed DataTypes to representations.
*
* Revision 1.2  2003/09/01 10:20:11  juengel
* DebugDrawings clean-up 2
* DebugImages clean-up
* MessageIDs clean-up
* Stopwatch clean-up
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.9  2003/05/12 10:29:24  dueffert
* unused variable warnings removed
*
* Revision 1.8  2003/03/31 16:54:48  goehring
* Improved BarCodeReader with less Errors
*
* Revision 1.7  2003/03/06 11:37:17  dueffert
* unused variable warning removed
*
* Revision 1.6  2003/02/21 18:32:04  roefer
* pColorTable -> colorTable finished
*
* Revision 1.5  2003/02/18 21:29:17  osterhues
* Changed all instances of ColorTable64 to new base class ColorTable
*
* Revision 1.4  2003/02/17 10:46:50  dueffert
* warnings removed
*
* Revision 1.3  2003/02/07 19:26:45  goehring
* Added Comments
*
* Revision 1.2  2003/02/05 19:20:30  goehring
* BarCodeReader - Prototype
*
* Revision 1.1  2003/01/29 10:37:21  juengel
* Added BarCodeReader.
*
*
*/
