/**
* @file AutoShutter.h
* 
* Definition of class AutoShutter
* This class chooses the shutter settings with the broadest dynamic range
*
* @author <A href=mailto:jochen@kerdels.de>Jochen Kerdels</A>
*/

#ifndef __AutoShutter_h_
#define __AutoShutter_h_

#include "SpecialVision.h"

/** A AutoShutter */
class AutoShutter : public SpecialVision
{
public:
  /** Constructor 
  * @param interfaces The interfaces of the SpecialVision module */
  AutoShutter(const SpecialVisionInterfaces& interfaces);

  /** Executes the module */
  virtual void execute();

  void reset();

  int state;

  double histograms[256][9];

  void makeHistogram(int which);

  void selectBest();
};

#endif// __AutoShutter_h_

/*
* Change log :
* 
* $Log: AutoShutter.h,v $
* Revision 1.3  2004/07/02 10:11:47  nistico
* Cloned main image processor and created
* SpecialLandmarks specialist for SLAM challenge
*
* Revision 1.2  2004/06/29 15:10:57  kerdels
* Special Vision AutoShutter...
*
* Revision 1.1  2004/06/28 10:54:34  kerdels
* added a class structure for a AutoShutter
*
* Revision 1.1  2004/06/28 10:51:04  kerdels
* added a class structure for a AutoShutter
*
*
*
*/
