/**
* @file AutoShutter.cpp
* 
* Implementation of class AutoShutter
*
* @author <A href=mailto:jochen@kerdels.de>Jochen Kerdels</A>
*/

#include "AutoShutter.h"
#include "Representations/Perception/CameraParameters.h"
#include "Representations/Perception/CameraInfo.h"



AutoShutter::AutoShutter(const SpecialVisionInterfaces& interfaces)
: SpecialVision(interfaces)
{
  reset();
}

void AutoShutter::reset()
{
  state = 0;
  for (int i = 0; i < 256; ++i)
    for (int j = 0; j < 9; ++j)
      histograms[i][j] = 0.0;
}

void AutoShutter::execute()
{
  switch (state) {
    case  0: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_low;
               tmp.theShutterSpeed = CameraParameters::shutter_slow;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  2: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_mid;
               tmp.theShutterSpeed = CameraParameters::shutter_slow;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  4: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_high;
               tmp.theShutterSpeed = CameraParameters::shutter_slow;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  6: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_low;
               tmp.theShutterSpeed = CameraParameters::shutter_mid;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  8: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_mid;
               tmp.theShutterSpeed = CameraParameters::shutter_mid;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  10: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_high;
               tmp.theShutterSpeed = CameraParameters::shutter_mid;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  12: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_low;
               tmp.theShutterSpeed = CameraParameters::shutter_fast;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  14: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_mid;
               tmp.theShutterSpeed = CameraParameters::shutter_fast;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  16: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_high;
               tmp.theShutterSpeed = CameraParameters::shutter_fast;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  1:
    case  3:
    case  5:
    case  7:
    case  9:
    case 11:
    case 13:
    case 15:
    case 17: makeHistogram(state / 2); break;
    case 18: selectBest(); break;
  }
  if (state < 18)
  {
    state++;
    specialPercept.type = SpecialPercept::autoShutter;
    specialPercept.shutterSelected = false;
  }
  else
  {
    specialPercept.type = SpecialPercept::autoShutter;
    specialPercept.shutterSelected = true;
    reset();
  }
}

void AutoShutter::makeHistogram(int which)
{
  const double sampleCount = 2500;
  int i;
  for (i = 0; i < sampleCount; ++i)
    ++histograms[image.image[rand()%cameraResolutionHeight_ERS7][0][rand()%cameraResolutionWidth_ERS7]][which];
  histograms[0][which] /= sampleCount;
  for (i = 1; i < 256; ++i)
    histograms[i][which] = histograms[i-1][which] + (histograms[i][which] / sampleCount);
}

void AutoShutter::selectBest()
{
  double a;
  double min = 256;
  int minid = -1;
  for (int i = 0; i < 9; ++i) {
    a = 0;
    for (int j = 0; j < 256; ++j) {
      a += fabs(histograms[j][i] - (double(j) / 255.0));
    }
    if (a < min)
    {
      min = a;
      minid = i;
    }
  }

  if (minid >= 0)
    switch (minid)
    {
    case  0: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_low;
               tmp.theShutterSpeed = CameraParameters::shutter_slow;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  1: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_mid;
               tmp.theShutterSpeed = CameraParameters::shutter_slow;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  2: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_high;
               tmp.theShutterSpeed = CameraParameters::shutter_slow;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  3: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_low;
               tmp.theShutterSpeed = CameraParameters::shutter_mid;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  4: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_mid;
               tmp.theShutterSpeed = CameraParameters::shutter_mid;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  5: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_high;
               tmp.theShutterSpeed = CameraParameters::shutter_mid;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  6: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_low;
               tmp.theShutterSpeed = CameraParameters::shutter_fast;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  7: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_mid;
               tmp.theShutterSpeed = CameraParameters::shutter_fast;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    case  8: {
               CameraParameters tmp;
               tmp.theGain         = CameraParameters::gain_high;
               tmp.theShutterSpeed = CameraParameters::shutter_fast;
               tmp.theWhiteBalance = CameraParameters::wb_indoor_mode;
               sensors.setCameraParameters(tmp);
             } break;
    }
}

/*
* Change log :
* 
* $Log: AutoShutter.cpp,v $
* Revision 1.2  2004/06/29 15:10:57  kerdels
* Special Vision AutoShutter...
*
* Revision 1.1  2004/06/28 10:54:34  kerdels
* added a class structure for a AutoShutter
*
* Revision 1.1  2004/06/28 10:51:04  kerdels
* added a class structure for a AutoShutter
*
*
*
*/
