/**
 * @file DefaultSoundControl.h
 * 
 * Implementation of class DefaultSoundControl.
 *
 * @author <a href="mailto:Oliver.Giese@uni-dortmund.de">Oliver Giese</a>
 * @author <a href="mailto:matthias.hebbel@uni-dortmund.de">Matthias Hebbel</a>
 */

#ifndef __DefaultSoundControl_h_
#define __DefaultSoundControl_h_

#include "SoundControl.h"

/** 
* @class DefaultSoundControl
*
* The default solution of the SoundControl module
 * @author <a href="mailto:Oliver.Giese@uni-dortmund.de">Oliver Giese</a>
 * @author <a href="mailto:matthias.hebbel@uni-dortmund.de">Matthias Hebbel</a>
*/
class DefaultSoundControl : public SoundControl
{
  public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the HeadControl module.
  */
    DefaultSoundControl(const SoundControlInterfaces& interfaces);

    /** Destructor */
    virtual ~DefaultSoundControl();
    virtual void execute();
    
    bool playingWave;
  
  protected:
    bool loadWavefile(const char* filename, int index);
    bool checkWaveHeader(const char* filename, int index);
    void playWave(SoundData* soundData, int index);
    void fillWaveBuffer(SoundData* soundData, int index);

    char* waveData[SoundRequest::numOfSoundIDs];
    char waveHeader[100];
    unsigned long actWavePosition;
    unsigned long startWavePosition[SoundRequest::numOfSoundIDs];
    unsigned long waveLength[SoundRequest::numOfSoundIDs];
    
    unsigned long lastTransmittedMessageTimestamp;

    SoundRequest::SoundID lastSound;
};

#endif// __DefaultSoundControl_h_

/*
 * Change log :
 * 
 * $Log: DefaultSoundControl.h,v $
 * Revision 1.2  2004/05/22 22:52:03  juengel
 * Renamed ballP_osition to ballModel.
 *
 * Revision 1.1.1.1  2004/05/22 17:21:31  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2004/03/08 02:11:52  roefer
 * Interfaces should be const
 *
 * Revision 1.1  2003/10/06 14:10:14  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.7  2003/04/15 15:52:09  risler
 * DDD GO 2003 code integrated
 *
 * Revision 1.8  2003/04/08 21:20:36  max
 * preload wave files at startup
 *
 * Revision 1.7  2003/04/06 12:32:48  max
 * added ddd sound stuff
 *
 * Revision 1.6  2002/11/28 23:07:02  hebbel
 * using variable isInUse of soundData
 *
 * Revision 1.5  2002/11/28 14:20:53  hebbel
 * Cleaned up and added support for playing *.wav files
 *
 * Revision 1.4  2002/09/22 18:40:53  risler
 * added new math functions, removed GTMath library
 *
 * Revision 1.3  2002/09/11 00:06:58  loetzsch
 * continued change of module/solution mechanisms
 *
 * Revision 1.2  2002/09/10 21:07:30  loetzsch
 * continued change of module/solution mechanisms
 *
 * Revision 1.1  2002/09/10 15:36:16  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.12  2002/08/30 14:34:54  dueffert
 * removed unused includes
 *
 * Revision 1.11  2002/07/23 13:33:43  loetzsch
 * new streaming classes
 *
 * removed many #include statements
 *
 * Revision 1.10  2002/05/27 16:15:55  schley
 * ballp_osition can be transmitted
 *
 * Revision 1.9  2002/05/27 15:39:04  fischer
 * Added SoundState (Sender and Receiver)
 *
 * Revision 1.8  2002/05/22 13:46:22  fischer
 * Changed SoundInProcessor interface to accept WorldState
 *
 * Revision 1.7  2002/05/21 11:44:47  hebbel
 * added table for signalcoding
 *
 * Revision 1.6  2002/05/17 11:20:57  fischer
 * ball position exchange via acoustic communication
 *
 * Revision 1.5  2002/05/15 10:20:00  schley
 * moved the audio.cfg to SoundProtocol
 *
 * Revision 1.4  2002/05/15 07:28:18  hebbel
 * Removed mute, uses Soundprotocol instead, plays wave for patternchallenge
 *
 * Revision 1.3  2002/05/14 18:52:58  hebbel
 * Added variable mute
 *
 * Revision 1.2  2002/05/13 13:29:43  schley
 * Deconstructor added and audio.cfg
 *
 * Revision 1.1.1.1  2002/05/10 12:40:16  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.3  2002/05/06 15:06:54  schley
 * Added the PCMCreator
 *
 * Revision 1.2  2002/05/03 13:47:57  giese
 * Added timestamp to AcousticMessage
 *
 * Revision 1.1  2002/04/28 19:14:12  giese
 * SoundPlay added...
 *
 *
 * 
 */
