/**
* @file SensorDataProcessorSelector.h
*
* Declaration of class SensorDataProcessorSelector
*
* @author Martin Ltzsch
*/

#ifndef __SensorDataProcessorSelector_h_
#define __SensorDataProcessorSelector_h_

#include "Tools/Module/ModuleHandler.h"
#include "DefaultSensorDataProcessor.h"
#include "BB2004SensorDataProcessor.h"

/**
* @class SensorDataProcessorSelector
* 
* A module selector for sensor data processors.
*
* @author Martin Ltzsch
*/
class SensorDataProcessorSelector : public ModuleSelector, public SensorDataProcessorInterfaces
{
public:
/**
* Constructor.
* @param handler The module handler of the process.
* @param interfaces The paramters of the HeadControl module.
  */
  SensorDataProcessorSelector(ModuleHandler &handler, 
    const SensorDataProcessorInterfaces& interfaces)
    : ModuleSelector(SolutionRequest::sensorDataProcessor),
    SensorDataProcessorInterfaces(interfaces)
  {    
    handler.setModuleSelector(SolutionRequest::sensorDataProcessor,this);
  };

  
  /** 
  * Is called on start and when the selected solution changes
  * to create a specific solution.
  * @param id The id of the solution to create
  * @return The created solution or 0
  */
  virtual Module* createSolution(SolutionRequest::ModuleSolutionID id)
  {
    switch(id)
    {
    case SolutionRequest::defaultSensorDataProcessor:
      return new DefaultSensorDataProcessor(*this);

    case SolutionRequest::bb2004SensorDataProcessor:
      return new BB2004SensorDataProcessor(*this);

    default:
      return 0;
    }
  }
};  

#endif //__SensorDataProcessorSelector_h_

/*
* Change log:
*
* $Log: SensorDataProcessorSelector.h,v $
* Revision 1.1.1.1  2004/05/22 17:21:30  cvsadm
* created new repository GT2004_WM
*
* Revision 1.4  2004/03/08 02:11:52  roefer
* Interfaces should be const
*
* Revision 1.3  2004/02/04 13:41:33  roefer
* Some place holders for BB2004 modules added
*
* Revision 1.2  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.1  2003/10/06 14:10:14  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.5  2002/09/17 23:55:22  loetzsch
* - unraveled several datatypes
* - changed the WATCH macro
* - completed the process restructuring
*
* Revision 1.4  2002/09/12 12:24:09  juengel
* continued change of module/solution mechanisms
*
* Revision 1.3  2002/09/10 21:07:30  loetzsch
* continued change of module/solution mechanisms
*
* Revision 1.2  2002/09/10 17:53:40  loetzsch
* First draft of new Module/Solution Mechanisms
*
* Revision 1.1  2002/09/10 15:36:16  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.2  2002/05/14 12:39:04  dueffert
* corrected some documentation mistakes
*
* Revision 1.1.1.1  2002/05/10 12:40:15  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.2  2002/04/02 13:10:20  dueffert
* big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
*
* Revision 1.1  2002/02/05 03:51:14  loetzsch
* added a few new module selectors
*
*/
