/**
* @file SensorBehaviorControlSelector.h
* 
* Definition of class SensorBehaviorControlSelector
*
* @author Max Risler
* @author Martin Ltzsch
* @author Matthias Jngel
*/

#ifndef __SensorBehaviorControlSelector_h_
#define __SensorBehaviorControlSelector_h_

#include "Tools/Module/ModuleSelector.h"

#include "ObstacleAvoiderOnGreenField.h"
#include "ObstacleAvoiderOnGreenFieldERS7.h"
#include "MotionRecognition.h"
#include "SimpleMotionRecognition.h"
#include "BB2004Calibrator.h"
#include "ImageSaver.h"

/**
* @class SensorBehaviorControlSelector
* 
* A module selector for sensor data to motion request modules.
*
* @author Martin Ltzsch
*/
class SensorBehaviorControlSelector : public ModuleSelector, public SensorBehaviorControlInterfaces
{
public:
/**
* Constructor.
* @param handler The module handler of the process.
* @param interfaces The paramters of the SensorBehaviorControl module.
  */
  SensorBehaviorControlSelector(ModuleHandler &handler,const SensorBehaviorControlInterfaces& interfaces)
    : ModuleSelector(SolutionRequest::sensorBehaviorControl),
    SensorBehaviorControlInterfaces(interfaces)
  {
    handler.setModuleSelector(SolutionRequest::sensorBehaviorControl, this);
  }    
  
  /** 
  * Is called on start and when the selected solution changes
  * to create a specific solution.
  * @param id The id of the solution to create
  * @return The created solution or 0
  */
  virtual Module* createSolution(SolutionRequest::ModuleSolutionID id)
  {
    switch(id)
    {
    case SolutionRequest::obstacleAvoiderOnGreenField:
      return new ObstacleAvoiderOnGreenField(*this);
      
    case SolutionRequest::obstacleAvoiderOnGreenFieldERS7:
      return new ObstacleAvoiderOnGreenFieldERS7(*this);
      
    case SolutionRequest::motionrecognition:
      return new MotionRecognition(*this);
      
    case SolutionRequest::simpleMotionRecognition:
      return new SimpleMotionRecognition(*this);
      
    case SolutionRequest::bb2004Calibrator:
      return new BB2004Calibrator(*this);

    case SolutionRequest::imageSaver:
      return new ImageSaver(*this);
      
    default:
      return 0;
    }
  }
  
};

#endif //__SensorBehaviorControlSelector_h_

/*
* Change log:
*
* $Log: SensorBehaviorControlSelector.h,v $
* Revision 1.3  2004/06/16 21:00:02  goehring
* ImageSaver added
*
* Revision 1.2  2004/05/22 20:34:43  juengel
* Removed AlLx_RemotePresence.
*
* Revision 1.1.1.1  2004/05/22 17:20:53  cvsadm
* created new repository GT2004_WM
*
* Revision 1.8  2004/03/08 02:11:50  roefer
* Interfaces should be const
*
* Revision 1.7  2004/03/04 23:00:54  roefer
* Added (so far empty) BB2004Calibrator
*
* Revision 1.6  2004/02/27 13:37:16  jhoffman
* added obstacle avoiding "sensor behavior control" for ers7
*
* Revision 1.5  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.4  2004/01/08 21:59:18  richert
* added Module SimpleMotionRecognition
*
* Revision 1.3  2003/12/12 17:09:37  richert
* added new solution motionrecognition
*
* Revision 1.2  2003/11/17 14:56:04  urban
* added SensorBehaviorControl-solution "AlLx RemotePresence" and RobotControl-dialogbar "AlLx Joystick"
*
* Revision 1.1  2003/10/06 14:10:15  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/09/27 18:40:47  loetzsch
* removed AnnaSeghersSchoolDemo again
*
* Revision 1.2  2003/09/14 17:47:38  loetzsch
* added solution AnnaSeghersSchooDemo
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.7  2003/01/30 18:26:40  jhoffman
* added ObstacleAvoider
*
* Revision 1.6  2002/12/05 15:58:52  goehring
* DanielTest implemented
*
* Revision 1.5  2002/12/03 19:00:28  loetzsch
* doen't compile
*
* Revision 1.4  2002/12/03 16:46:42  goehring
* added daniel test behavior
*
* Revision 1.3  2002/11/20 15:44:49  juengel
* Added cameraMatrix to SensorBehaviorControlInterfaces.
*
* Revision 1.2  2002/11/18 19:24:16  juengel
* Line Follower added.
*
* Revision 1.1  2002/11/07 17:27:58  loetzsch
* renamed Module SensorDataToMotionRequest to SensorBehaviorControl
*
* Revision 1.2  2002/09/12 12:24:09  juengel
* continued change of module/solution mechanisms
*
* Revision 1.1  2002/09/10 15:36:16  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.3  2002/07/29 17:44:48  jhoffman
* added braitenberg vehicle-style behavior (or actually: a "sensor data to motion request")
*
* Revision 1.2  2002/05/14 12:39:04  dueffert
* corrected some documentation mistakes
*
* Revision 1.1.1.1  2002/05/10 12:40:15  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.1  2002/02/05 03:51:47  loetzsch
* added a few new module selectors
*
*/
