/**
* @file ObstacleAvoiderOnGreenField.h
* Class that generates Motion requests in a fashion similar to the ObstacleAvoiderOnGreenField ve.
* 
* @author <A href=mailto:jhoffman@informatik.hu-berlin.de>Jan Hoffmann</A>
*/
 
#ifndef __ObstacleAvoiderOnGreenField_h_
#define __ObstacleAvoiderOnGreenField_h_

#include "SensorBehaviorControl.h"
#include "Tools/Math/PIDsmoothedValue.h"
#include "Tools/Debugging/DebugImages.h"
#include "Tools/Debugging/DebugDrawings.h"


/**
* Class that generates Motion requests in a fashion similar to the Braitenberg but also uses
* the PSD sensor to not run into things.
*/
class ObstacleAvoiderOnGreenField : public SensorBehaviorControl
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the SensorBehaviorControl module.
  */
  ObstacleAvoiderOnGreenField(const SensorBehaviorControlInterfaces& interfaces);
  
  /** some init's that are only done when the module is called
  * for the first time (or it it hasn't been called for a while) 
  * such as setting the headcontrol-mode
  */
  void init();
  /** the "main" module where all the magic is happening */
  virtual void execute();
  /** calibrate the psd (while standing still) to the minimum 
  * value it measures */
  void calibrate();
  /** currently no debug messages are handled */
  virtual bool handleMessage(InMessage& message);

private:
  double maxSpeedX, distanceToGround, distanceOffset, distanceControlInterval;
  PIDsmoothedValue speedX, speedY, speedPhi;
  int gridSize, greenOrLight;
  unsigned long timeOfLastExecute, timeToCalibrate;
	ColorTable64 localColTable;
	bool localColTableInitialized;

  // images for debugging
  DECLARE_DEBUG_IMAGE(classificationY);
};

#endif// __ObstacleAvoiderOnGreenField_h_

/*
* Change log :
* 
* $Log: ObstacleAvoiderOnGreenField.h,v $
* Revision 1.1.1.1  2004/05/22 17:20:52  cvsadm
* created new repository GT2004_WM
*
* Revision 1.4  2004/03/08 02:11:50  roefer
* Interfaces should be const
*
* Revision 1.3  2004/01/12 16:00:47  jhoffman
* *** empty log message ***
*
* Revision 1.2  2003/12/09 16:28:15  jhoffman
* - added sounds to obstacle avoider on green field
* - added calibration mode for obstacle avoider on green field
*
* Revision 1.1  2003/10/06 14:10:15  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.3  2003/06/11 16:10:31  dueffert
* some cleanup
*
* Revision 1.2  2003/02/02 23:29:21  jhoffman
* adjustments for it to work reliably and with any walking engine
*
* Revision 1.1  2003/01/30 18:26:40  jhoffman
* added ObstacleAvoider
*
*
*
*/
