/**
* @file ImageSaver.h
* 
* @author <A href=mailto:goehring@informatik.hu-berlin.de>Daniel Goehring</A>
*/
 
#ifndef __ImageSaver_h_
#define __ImageSaver_h_

#include "SensorBehaviorControl.h"
#include "Tools/Debugging/DebugImages.h"
#include "Tools/Debugging/DebugDrawings.h"


class ImageSaver : public SensorBehaviorControl
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the SensorBehaviorControl module.
  */
  ImageSaver(SensorBehaviorControlInterfaces& interfaces);
  
 void init();
  /** the "main" module where all the magic is happening */
  virtual void execute();
  /** 
  * calibrate the psd (while standing still) to the minimum 
  * currently no debug messages are handled 
  */
  virtual bool handleMessage(InMessage& message);

private:

  HeadControlMode hcm;
  
  unsigned long lastSavingTime;
  // images for debugging
  DECLARE_DEBUG_IMAGE(classificationY);
};

#endif// __ImageSaver_h_

/*
* Change log :
*
* $Log: ImageSaver.h,v $
* Revision 1.4  2004/06/28 01:23:02  juengel
* Head button switches head-control-mode.
*
* Revision 1.3  2004/06/17 13:31:26  risler
* warning removed
*
* Revision 1.2  2004/06/16 21:47:18  goehring
* review
*
* Revision 1.1  2004/06/16 20:57:07  goehring
* no message
*
* 
*/
