/**
* @file JansVisionSandbox.cpp
* This file contains a class that demonstrates walking.
* 
* @author <A href=mailto: goehring@informatik.hu-berlin.de>Daniel Goehring</A>
*/

#include "ImageSaver.h"
#include "Tools/Debugging/GenericDebugData.h"
#include "Representations/Perception/JPEGImage.h"


ImageSaver::ImageSaver(SensorBehaviorControlInterfaces& interfaces)
: SensorBehaviorControl(interfaces)
{
  lastSavingTime = SystemCall::getCurrentSystemTime();
  for(int i = 0; i < 14; i++) ledRequest.faceLED[i] = LEDRequest::oooo;
  
  ledRequest.headWhiteLED = LEDRequest::oooo;
  ledRequest.headOrangeLED = LEDRequest::oooo;
  
  ledRequest.backFrontBlueLED = LEDRequest::oooo;
  ledRequest.backMiddleOrangeLED = LEDRequest::oooo;
  ledRequest.backRearRedLED = LEDRequest::oooo;
  
  ledRequest.backFrontWhiteLED = LEDRequest::oooo;
  ledRequest.backMiddleWhiteLED = LEDRequest::oooo;
  ledRequest.backRearWhiteLED = LEDRequest::oooo;

  hcm.headControlMode = HeadControlMode::searchForBall;
}

void ImageSaver::init()
{
}

void ImageSaver::execute()
{
  motionRequest.motionType = MotionRequest::stand;
  headControlMode.headControlMode = hcm.headControlMode;

  // head button pressed short and released
  if(
    !robotState.getButtonPressed(BodyPercept::head) &&
    robotState.getButtonPressedTime(BodyPercept::head) > 100 &&
    robotState.getButtonPressedTime(BodyPercept::head) < 1000 &&
    SystemCall::getTimeSince(robotState.getButtonTime(BodyPercept::head)) < 700
    )
  {
    switch(hcm.headControlMode)
    {
    case HeadControlMode::lookStraightAhead: hcm.headControlMode = HeadControlMode::stayAsForced; break;
    case HeadControlMode::stayAsForced: hcm.headControlMode = HeadControlMode::searchForBall; break;
    case HeadControlMode::searchForBall: hcm.headControlMode = HeadControlMode::lookStraightAhead; break;
    }
  }
  
  if (SystemCall::getCurrentSystemTime() - lastSavingTime > 3000)
  {
    ledRequest.backFrontWhiteLED = LEDRequest::llll;
    ledRequest.backMiddleWhiteLED = LEDRequest::llll;
    ledRequest.backRearWhiteLED = LEDRequest::llll;
    if (robotState.getButtonPressed(BodyPercept::backBack)||
      robotState.getButtonPressed(BodyPercept::backFront)||
      robotState.getButtonPressed(BodyPercept::backMiddle))
    {
      lastSavingTime = SystemCall::getCurrentSystemTime();
      OUTPUT(idJPEGImage,bin,JPEGImage(image) << cameraMatrix);
      ledRequest.backFrontWhiteLED = LEDRequest::oooo;
      ledRequest.backMiddleWhiteLED = LEDRequest::oooo;
      ledRequest.backRearWhiteLED = LEDRequest::oooo;
    }
  }
}



bool ImageSaver::handleMessage(InMessage& message)
{
  return false;
}


/*
* Change log :
* 
* $Log: ImageSaver.cpp,v $
* Revision 1.6  2004/06/28 01:23:02  juengel
* Head button switches head-control-mode.
*
* Revision 1.5  2004/06/21 18:52:37  dueffert
* shiny new bug fixed
*
* Revision 1.4  2004/06/21 18:28:42  dueffert
* easier button interface
*
* Revision 1.3  2004/06/20 18:16:19  dueffert
* ImageSaver may work now
*
* Revision 1.2  2004/06/16 21:47:18  goehring
* review
*
* Revision 1.1  2004/06/16 20:57:07  goehring
* no message
*
*
*/
