/**
* @file SensorActorLoopSelector.h
* 
* Definition of class SensorActorLoopSelector
*
* @author Matthias Jngel
*/

#ifndef __SensorActorLoopSelector_h_
#define __SensorActorLoopSelector_h_

#include "Tools/Module/ModuleSelector.h"

#include "DemoSensorActorLoop.h"

/**
* @class SensorActorLoopSelector
*
* A module selector for SensorActorLoopSelector modules.
*/
class SensorActorLoopSelector : public ModuleSelector, public SensorActorLoopInterfaces
{
public:
/**
* Constructor.
* @param handler The module handler of the process.
* @param interfaces The paramters of the SensorActorLoop module.
  */
  SensorActorLoopSelector(
    ModuleHandler &handler,
    SensorActorLoopInterfaces& interfaces) 
    : ModuleSelector(SolutionRequest::sensorActorLoop),
    SensorActorLoopInterfaces(interfaces)
  {
    handler.setModuleSelector(SolutionRequest::sensorActorLoop, this);
  }
  
    /** 
  * Is called on start and when the selected solution changes
  * to create a specific solution.
  * @param id The id of the solution to create
  * @return The created solution or 0
  */
  virtual Module* createSolution(SolutionRequest::ModuleSolutionID id)
  {
    switch(id)
    {
    case SolutionRequest::demoSensorActorLoop:
      return new DemoSensorActorLoop(*this);

    default:
      return 0;
    }
  }
  
};

#endif // __SensorActorLoopSelector_h_

/*
* Change log :
* 
* $Log: SensorActorLoopSelector.h,v $
* Revision 1.2  2004/05/22 18:47:42  juengel
* Removed some solutions.
*
* Revision 1.1.1.1  2004/05/22 17:20:50  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.1  2003/10/29 13:02:51  juengel
* Added module SensorActorLoop.
*
*/
