/**
* @file DemoSensorActorLoop.h
*
* Definition of class DemoSensorActorLoop.
* 
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Juengel</a>
*/

#ifndef __DemoSensorActorLoop_h_
#define __DemoSensorActorLoop_h_

#include "SensorActorLoop.h"

/**
* @class DemoSensorActorLoop
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Juengel</a>
*/
class DemoSensorActorLoop : public SensorActorLoop, public RobotDimensions
{
public:
/** 
* Constructor 
* @param interfaces The paramters of the DemoSensorActorLoop module.
  */
  DemoSensorActorLoop(SensorActorLoopInterfaces& interfaces);
  
  /** Executes the module */
  virtual void execute();
  
  /** 
  * Called from a MessageQueue to distribute messages.
  * Use message.getMessageID to decide if the message is relavant for 
  * the MesssageHandler derivate.
  * Use message.bin, message.text or message.config as In streams to get the data from.
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);
  
private:
  unsigned long timeOfLastExecute;
  unsigned long timeOfLastStateChange;

  void init();
  void execute_sleep();
  void execute_fly();
  void execute_motionClone();
  void execute_waveHand();

  enum {sleep, fly, motionClone, waveHand} state;

  /** counter used for tail wag*/
  int tailCyclePosition;
};

#endif// __DemoSensorActorLoop_h_

/*
* Change log :
* 
* $Log: DemoSensorActorLoop.h,v $
* Revision 1.1.1.1  2004/05/22 17:20:49  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2004/01/13 15:59:38  loetzsch
* made compilable
*
* Revision 1.1  2003/10/29 13:02:51  juengel
* Added module SensorActorLoop.
*
*
*/
