/**
* @file Modules/SelfLocator/SpecialPerceptSelfLocator.h
* 
* This file contains a class for self-localization based on
* special percepts, e.g. checkerboard percepts.
*
* @author <a href="mailto:dueffert@informatik.hu-berlin.de">Uwe Dffert</a>
*
*/

#ifndef __SpecialPerceptSelfLocator_h_
#define __SpecialPerceptSelfLocator_h_

#include "SelfLocator.h"
#include "Tools/RingBuffer.h"
//#include "Tools/Math/Matrix2x2.h"
//#include "Tools/Math/Vector2.h"
#include "Tools/Math/PIDsmoothedValue.h"


/**
* Class for self-localization based on special percepts, e.g. checkerboard percepts
* (see ImageProcessor/checkerboardDetector.* for details)
*/
class SpecialPerceptSelfLocator : public SelfLocator
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the SelfLocator module.
  */
  SpecialPerceptSelfLocator(const SelfLocatorInterfaces& interfaces);
  
  /**
  * Destructor.
  */
  ~SpecialPerceptSelfLocator() {}
  
  /** Executes the module */
  virtual void execute();

private:
  Pose2D lastRobotPose;
  int psdCrashCount;
  Pose2D lastOdometry;
  
/*
  //6x6-Kalman:
  Matrix_3x6 H;
  Matrix_6x6 A;
  Matrix_6x1 xpre;
  Matrix_6x6 P;
  Matrix_6x6 Ppre;
  Matrix_3x3 R;
  Matrix_6x3 K;
*/

/*
  //2x2-Kalman:
  Vector2<double> H;
  Matrix2x2<double> A;
  Vector2<double> xpre;
  Matrix2x2<double> P;
  Matrix2x2<double> Ppre;
  double R;
  Vector2<double> K;
*/

/*
  //quadratische Kurve:
  RingBuffer<Pose2D,12> perceptPoseBuffer;
  RingBuffer<unsigned long,12> perceptTimeBuffer;
*/
  //PIDsmoothed:
  PIDsmoothedValue robotPosX, robotPosY, robotPosR;
  unsigned long lastFrame;
  bool lastWasOutlier;
};

#endif// __SpecialPerceptSelfLocator_h_

/*
* Change log :
* 
* $Log: SpecialPerceptSelfLocator.h,v $
* Revision 1.1.1.1  2004/05/22 17:20:49  cvsadm
* created new repository GT2004_WM
*
* Revision 1.5  2004/03/15 12:34:05  dueffert
* cool filter for single outliers implemented
*
* Revision 1.4  2004/03/08 02:11:49  roefer
* Interfaces should be const
*
* Revision 1.3  2004/01/16 15:47:51  dueffert
* some improvements
*
* Revision 1.2  2003/11/10 13:34:07  dueffert
* checkerboard localization improved
*
* Revision 1.1  2003/10/06 14:10:15  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.3  2003/08/09 14:53:10  dueffert
* files and docu beautified
*
* Revision 1.2  2003/07/30 14:47:46  dueffert
* SpecialPerceptSelfLocator for Checkboard added
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2003/03/31 21:01:44  roefer
* Moved class Field to Tools
*
* Revision 1.1  2003/01/22 14:59:49  dueffert
* checkerboard stuff added
*
*
*/
