/**
* @file Modules/SelfLocator/OdometrySelfLocator.h
* 
* This file contains a class for self-localization based on odometry only.
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Juengel</a>
*
*/

#ifndef __OdometrySelfLocator_h_
#define __OdometrySelfLocator_h_

#include "SelfLocator.h"

/**
* Class for self-localization based on odometry 
*/
class OdometrySelfLocator : public SelfLocator
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the SelfLocator module.
  */
  OdometrySelfLocator(const SelfLocatorInterfaces& interfaces);
  
  /**
  * Destructor.
  */
  ~OdometrySelfLocator() {}
  
  /** Executes the module */
  virtual void execute();

  Pose2D referencePose;
  Pose2D referenceOdometry;
  unsigned long int timeOfLastExecute;
};

#endif// __OdometrySelfLocator_h_

/*
* Change log :
* 
* $Log: OdometrySelfLocator.h,v $
* Revision 1.1.1.1  2004/05/22 17:20:48  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2004/03/08 02:11:48  roefer
* Interfaces should be const
*
* Revision 1.1  2003/10/06 14:10:15  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.2  2003/03/31 21:01:44  roefer
* Moved class Field to Tools
*
* Revision 1.1  2003/01/12 15:24:47  juengel
* Added OdometrySelfLocator
*
*/
