/**
 * @file Modules/SelfLocatorMotionRatingSelfLocator.cpp
 *
 * @author
 */

#include "MotionRatingSelfLocator.h"


const char * flagType(Flag::FlagType type)
{
  switch (type)
  {
  case Flag::pinkAboveYellow:
    return "Pink above Yellow";
  case Flag::pinkAboveSkyblue:
    return "Pink above Skyblue";
  case Flag::yellowAbovePink:
    return "Yellow above Pink";
  case Flag::skyblueAbovePink:
    return "Skyblue above Pink";
  default:
    return "???";
  }
}

//////////////////////////////////////////////////////////////////////
// Konstruktion/Destruktion
//////////////////////////////////////////////////////////////////////

MotionRatingSelfLocator::MotionRatingSelfLocator(SelfLocatorInterfaces& interfaces)
:SelfLocator(interfaces),distanceToFlag(0),firstflag(Flag::numberOfFlagTypes)
{ 
  robotPose.translation.x=.0;
  robotPose.translation.y=.0;
  robotPose.rotation=.0;
  robotPose.setValidity(.0);

}

MotionRatingSelfLocator::~MotionRatingSelfLocator()
{

}

void MotionRatingSelfLocator::execute()
{
  int num=landmarksPercept.numberOfFlags;

  //char message[50];
  if (num<=0) {
    //OUTPUT(idText,text, "number of flags: zero\r\n" );
    return;
  }

  Flag flag;
  if (firstflag==Flag::numberOfFlagTypes)
  {
    flag=landmarksPercept.flags[0];
    firstflag=flag.type;
    switch (firstflag)
    {
      case Flag::pinkAboveYellow:
        secondflag=Flag::yellowAbovePink;
        break;
      case Flag::pinkAboveSkyblue:
        secondflag=Flag::skyblueAbovePink;
        break;
      case Flag::yellowAbovePink:
        secondflag=Flag::pinkAboveYellow;
        break;
      case Flag::skyblueAbovePink:
        secondflag=Flag::pinkAboveSkyblue;
        break;
    }
  }
  else
  {
    int i=0;
    for (;i<num;i++)
    {
      if (landmarksPercept.flags[i].type==firstflag||landmarksPercept.flags[i].type==secondflag)
      {
        flag=landmarksPercept.flags[i];
        break;
      }
    }
    if (i==num) {
      //OUTPUT(idText,text, "number of flags reached\r\n" );
      return;
    }
  }
/*
/////////////////////////////
    char message[50];
    sprintf ( message, "number of flags: %d\r\n"
      "type: %s\r\n"
      "distance: %.2f (%.2f)\r\n"
      "angle: %.2f (%.2f)\r\n",
      num,flagType(flag.type),flag.distance,flag.distanceValidity,flag.angle,flag.angleValidity);
    OUTPUT(idText,text, message );
/////////////////////////////
*/
      double d=flag.distance;
      double alpha=flag.angle;

      if (flag.type==secondflag)
      {
        //d=-d;
        alpha=alpha-pi;
      }
      robotPose.rotation=alpha;
      //robotPose.translation.x=cos(alpha)*d;
      //robotPose.translation.y=sin(alpha)*d;
      robotPose.translation.x=d;
      robotPose.translation.y=0;

      robotPose.setValidity(1.0);
      

}
