/**
* @file Modules/SelfLocator/LinesTables2004.h
* 
* This file contains a class that represents the tables used for localization based on field lines.
*
* @author <A href=mailto:roefer@tzi.de>Thomas Rfer</A>
*/

#ifndef __LinesTables2004_h_
#define __LinesTables2004_h_

#include "LinesTables.h"

/**
* The class implements a lines-based Monte Carlo self-localization.
*/
class LinesTables2004
{
  protected:
    static Field field; /**< The field. */
    static ObservationTable<280,200,25>* observationTable; /**< The table maps points to closest edges. */
    static TemplateTable<50000>* templateTable; /**< The table contains candidate poses for certain distance measurements. */
    static int refCount; /**< A reference counter that ensures that the tables are only (de)allocated once. */

  public:
    /** 
    * Constructor.
    */
    LinesTables2004();

    /** 
    * Destructor.
    */
    ~LinesTables2004();
};

#endif// __LinesTables2004_h_

/*
* Change log :
* 
* $Log: LinesTables2004.h,v $
* Revision 1.2  2004/06/24 18:26:38  roefer
* Lines table redesign, should not influence the performance of GT2003SL
*
* Revision 1.1.1.1  2004/05/22 17:20:46  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2004/03/08 01:09:34  roefer
* Use of LinesTables2004 restructured
*
* Revision 1.1  2003/10/06 14:10:14  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.1  2003/05/22 07:53:05  roefer
* GT2003SelfLocator added
*
*/
