/**
 * @file Modules/SelfLocator/LinesTables2004.cpp
 * 
 * This file contains a class that represents the tables used for localization based on field lines.
 *
 * @author <A href=mailto:roefer@tzi.de>Thomas Rfer</A>
 */

#include "LinesTables2004.h"
#include "Tools/Debugging/Debugging.h"
#include "Tools/Streams/InStreams.h"

Field LinesTables2004::field;
ObservationTable<280,200,25>* LinesTables2004::observationTable = 0;
TemplateTable<50000>* LinesTables2004::templateTable = 0;
int LinesTables2004::refCount = 0;

//#define SAVE

LinesTables2004::LinesTables2004()
{
  if(!refCount++)
  {
    int i;
    observationTable = new ObservationTable<280,200,25>[LinesPercept::numberOfLineTypes + 1];
    templateTable = new TemplateTable<50000>[2];

#ifdef SAVE
    OutBinaryFile stream("lines04.tab");
    for(i = 0; i < LinesPercept::numberOfLineTypes + 1; ++i)
    {
      if(i == LinesPercept::field)
        observationTable[i].create(field,LinesPercept::xField);
      else if(i == LinesPercept::numberOfLineTypes)
        observationTable[i].create(field,LinesPercept::yField);
      else
        observationTable[i].create(field,LinesPercept::LineType(i));
      stream << observationTable[i];
    }
    templateTable[0].create(field,LinesPercept::yellowGoal);
    templateTable[LinesPercept::skyblueGoal - LinesPercept::yellowGoal].create(field,LinesPercept::skyblueGoal);
    stream << templateTable[0] << templateTable[1];
#else
    InBinaryFile stream("lines04.tab");
    if(stream.exists())
    {
      for(i = 0; i < LinesPercept::numberOfLineTypes + 1; ++i)
        stream >> observationTable[i];
      stream >> templateTable[0] >> templateTable[1];
    }
    else
    {
      OUTPUT(idText, text, "LinesTables2004 : lines04.tab not found");
    }
#endif
  }
}

LinesTables2004::~LinesTables2004()
{
  if(!--refCount)
  {
    delete [] observationTable;
    delete [] templateTable;
  }
}

/*
 * Change log :
 * 
 * $Log: LinesTables2004.cpp,v $
 * Revision 1.2  2004/06/24 18:26:38  roefer
 * Lines table redesign, should not influence the performance of GT2003SL
 *
 * Revision 1.1.1.1  2004/05/22 17:20:45  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2004/03/08 01:09:34  roefer
 * Use of LinesTables2004 restructured
 *
 * Revision 1.1  2003/10/06 14:10:14  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2003/05/22 07:53:05  roefer
 * GT2003SelfLocator added
 *
 */
