/**
 * @file Modules/SelfLocator/LinesTables.cpp
 * 
 * This file contains a class that represents the tables used for localization based on field lines.
 *
 * @author <A href=mailto:roefer@tzi.de>Thomas Rfer</A>
 */

#include "LinesTables.h"
#include "Tools/Debugging/Debugging.h"
#include "Tools/Streams/InStreams.h"

Field LinesTables::field;
ObservationTable<280,200,25>* LinesTables::observationTable = 0;
TemplateTable<10000>* LinesTables::templateTable = 0;
int LinesTables::refCount = 0;

//#define SAVE

LinesTables::LinesTables()
{
  if(!refCount++)
  {
    int i;
    observationTable = new ObservationTable<280,200,25>[LinesPercept::numberOfLineTypes];
    templateTable = new TemplateTable<10000>[LinesPercept::numberOfLineTypes];

#ifdef SAVE
    OutBinaryFile stream("lines.tab");
    for(i = 0; i < LinesPercept::numberOfLineTypes; ++i)
    {
      observationTable[i].create(field,LinesPercept::LineType(i));
      templateTable[i].create(field,LinesPercept::LineType(i));
      stream << observationTable[i] << templateTable[i];
    }
#else
    InBinaryFile stream("lines.tab");
    if(stream.exists())
      for(i = 0; i < LinesPercept::numberOfLineTypes; ++i)
        stream >> observationTable[i] >> templateTable[i];
    else
    {
      OUTPUT(idText, text, "LinesTables : lines.tab not found");
    }
#endif
  }
}

LinesTables::~LinesTables()
{
  if(!--refCount)
  {
    delete [] observationTable;
    delete [] templateTable;
  }
}

/*
 * Change log :
 * 
 * $Log: LinesTables.cpp,v $
 * Revision 1.2  2004/06/24 18:26:38  roefer
 * Lines table redesign, should not influence the performance of GT2003SL
 *
 * Revision 1.1.1.1  2004/05/22 17:20:45  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2004/03/08 01:09:34  roefer
 * Use of LinesTables restructured
 *
 * Revision 1.1  2003/10/06 14:10:14  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.1  2003/05/22 07:53:05  roefer
 * GT2003SelfLocator added
 *
 */
