/**
* 
* This file contains a class that estimates the distance to the border.
*
* @author <a href="mailto:juengel@informatik.hu-berlin.de">Matthias Juengel</a>
*/

#ifndef __DistanceToBorderEstimator_h_
#define __DistanceToBorderEstimator_h_

#include "SelfLocator.h"
#include "Tools/RingBufferWithSum.h"

/**
* The class implements a lines-based Monte Carlo self-localization.
*/
class DistanceToBorderEstimator : public SelfLocatorInterfaces
{
  public:
    /** 
    * Constructor.
    * @param interfaces The paramters of the SelfLocator module.
    */
    DistanceToBorderEstimator(const SelfLocatorInterfaces& interfaces);   
    /**
     * The function executes the module.
     */
    virtual void execute();
  private:
    RingBufferWithSum<10> distanceToBorderBuffer;
    int numberOfLinesPerceptsWithoutBorderPoints;
    int lastDistanceToBorder;
};

#endif// __DistanceToBorderEstimator_h_

/*
* Change log :
* 
* $Log: DistanceToBorderEstimator.h,v $
* Revision 1.1.1.1  2004/05/22 17:20:41  cvsadm
* created new repository GT2004_WM
*
* Revision 1.1  2004/03/27 16:17:24  juengel
* Added DistanceToBorderEstimator.
*
*
*/
