/**
* @file RobotStateDetector.h
* 
* This file contains a generic class for RobotStateDetector.
*/

#ifndef __RobotStateDetector_h_
#define __RobotStateDetector_h_

#include "Tools/Module/Module.h"
#include "Tools/RobotConfiguration.h"

#include "Representations/Perception/BodyPercept.h"
#include "Representations/Perception/CollisionPercept.h"
#include "Representations/Cognition/RobotState.h"


/**
* @class RobotStateDetectorInterfaces
* 
* The interfaces of the RobotStateDetector module.
*/
class RobotStateDetectorInterfaces
{
public:
  /** Constructor.*/
  RobotStateDetectorInterfaces(
    const BodyPercept& bodyPercept,
    const CollisionPercept& collisionPercept,
    RobotState& robotState
    )
    : 
    bodyPercept(bodyPercept),
    collisionPercept(collisionPercept),
    robotState(robotState)
  {}
  
  /** The BodyPercept*/
  const BodyPercept& bodyPercept;
  
  /** Detected collisions for each joint */
  const CollisionPercept& collisionPercept;

  /** The RobotState*/
  RobotState& robotState;
};

/**
* @class RobotStateDetector 
*
* The Base class for robot state detection
*
* Robot state detectors detect button messages and whether the robot is crashed.
*/
class RobotStateDetector : public Module, public RobotStateDetectorInterfaces, public RobotDimensions
{
public:
/*
* Constructor.
* @param interfaces The paramters of the RobotStateDetector module.
  */
  RobotStateDetector(const RobotStateDetectorInterfaces& interfaces)
    : RobotStateDetectorInterfaces(interfaces),
      RobotDimensions(getRobotConfiguration().getRobotDimensions())
  {}
  
  /** Destructor */
  virtual ~RobotStateDetector() {}
};

#endif //__RobotStateDetector_h_


/*
 * Change log :
 * 
 * $Log: RobotStateDetector.h,v $
 * Revision 1.2  2004/05/27 09:33:18  loetzsch
 * clean up
 *
 * Revision 1.1.1.1  2004/05/22 17:20:41  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.3  2004/03/08 02:11:45  roefer
 * Interfaces should be const
 *
 * Revision 1.2  2004/01/24 11:39:34  juengel
 * RobotStateDetector is derived from RobotDimensions
 *
 * Revision 1.1  2003/10/06 14:10:14  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.3  2003/09/26 21:23:20  loetzsch
 * renamed class JointState to CollisionPercept
 *
 * Revision 1.2  2003/09/26 15:27:49  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2003/06/19 09:04:20  goehring
 * JointState added
 *
 * Revision 1.2  2002/09/12 09:45:58  juengel
 * continued change of module/solution mechanisms
 *
 * Revision 1.1  2002/09/10 15:36:15  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.2  2002/08/22 14:41:03  risler
 * added some doxygen comments
 *
 * Revision 1.1.1.1  2002/05/10 12:40:15  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.4  2002/03/28 16:55:58  risler
 * RobotStateDetector receives BodyPercept instead of PerceptCollection
 * added switch duration in RobotStateDetector
 *
 * Revision 1.3  2001/12/21 14:09:39  roefer
 * Added several destructors
 *
 * Revision 1.2  2001/12/10 17:47:07  risler
 * change log added
 *
 */
