/**
* @file DefaultRobotStateDetector.h
*
* Definition of class DefaultRobotStateDetector
*
*/

#ifndef __DefaultRobotStateDetector_h_
#define __DefaultRobotStateDetector_h_

#include "RobotStateDetector.h"


#include "Tools/Debugging/Debugging.h" /////*****

/**
* @class DefaultRobotStateDetector
*
* A solution of the RobotStateDetector module.
*
* @author = Max Risler
*/
class DefaultRobotStateDetector : public RobotStateDetector
{
public:
  /** 
  * Constructor.
  * @param interfaces The paramters of the RobotStateDetector module.
  */
  DefaultRobotStateDetector(const RobotStateDetectorInterfaces& interfaces);

  /** Executes the module */
  virtual void execute();

private:

  void calculateCollisionState();

  void setNewButtonStatus();

  bool switchDown[BodyPercept::numOfSwitches];
  long switchDownTime[BodyPercept::numOfSwitches];
  long timeSinceLastCollision[6]; //here are the last collision time points
  long consecutiveCollisionTime[6]; //here are the consecutive collision time points
  long remindCollision; // time distance during which the last collision is remembered
  int getCollisionSide(); //on which side did more collisions occur
  void setCollisionOnLeftSide(bool collision); //add another collision to left side
  void setCollisionOnRightSide(bool collision);//add another collision to right side

  enum {middle = 0,
        left,
        right,
        robotSides};

  enum {maxFrameHistory = 200};

  bool numOfCollisions[maxFrameHistory][robotSides];


  /***/
  bool buttonPressed[BodyPercept::numOfSwitches]; //0 Button not pressed, 1 Button pressed
  long buttonTime[BodyPercept::numOfSwitches]; // The time as the button was pressed/released
  long buttonPressedTime[BodyPercept::numOfSwitches]; // How long the last button was pressed (after releasing it)
  long buttonDuration[BodyPercept::numOfSwitches]; // How long the button is pressed/released
  bool anyBackButtonPressed;  // The same information for any backbutton
  long anyBackButtonTime;
  long anyBackButtonPressedTime;
  long anyBackButtonDuration;
  /***/
};

#endif// __DefaultRobotStateDetector_h_

/*
 * Change log :
 * 
 * $Log: DefaultRobotStateDetector.h,v $
 * Revision 1.3  2004/06/23 11:02:26  goehring
 * Xabsl symbol collision-side added
 *
 * Revision 1.2  2004/05/24 14:14:26  juengel
 * New button evaluation.
 *
 * Revision 1.1.1.1  2004/05/22 17:20:41  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.3  2004/05/11 06:59:05  brueckne
 * added new way to know how long a button is/was pressed/released (not ready yet)
 *
 * Revision 1.2  2004/03/08 02:11:45  roefer
 * Interfaces should be const
 *
 * Revision 1.1  2003/10/06 14:10:14  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.7  2003/06/21 13:07:36  goehring
 * CollisionStateSymbol modelling changed
 *
 * Revision 1.6  2003/06/20 16:57:46  goehring
 * CollisionDetectorValues improved
 *
 * Revision 1.5  2003/06/20 14:50:07  risler
 * numOfSwitches added
 *
 * Revision 1.4  2003/06/20 10:29:27  goehring
 * MotionCombination thresholds implemented, Review
 *
 * Revision 1.3  2002/10/14 13:14:24  dueffert
 * doxygen comments corrected
 *
 * Revision 1.2  2002/09/12 09:45:58  juengel
 * continued change of module/solution mechanisms
 *
 * Revision 1.1  2002/09/10 15:36:15  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.2  2002/08/22 14:41:03  risler
 * added some doxygen comments
 *
 * Revision 1.1.1.1  2002/05/10 12:40:15  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.4  2002/03/28 16:55:58  risler
 * RobotStateDetector receives BodyPercept instead of PerceptCollection
 * added switch duration in RobotStateDetector
 *
 * Revision 1.3  2002/03/28 15:19:20  risler
 * implemented switch messages in RobotStateDetector
 *
 * Revision 1.2  2001/12/10 17:47:06  risler
 * change log added
 *
 */
