/**
* @file PlayersLocatorSelector.h
* 
* Definition of class PlayersLocatorSelector
*
* @author Max Risler
* @author Martin Ltzsch
* @author Matthias Jngel
*/

#ifndef __PlayersLocatorSelector_h_
#define __PlayersLocatorSelector_h_

#include "Tools/Module/ModuleSelector.h"
#include "GO2003PlayersLocator.h"

/**
* PlayersLocator selection module.
*
* A selector for player locators.
*/
class PlayersLocatorSelector : public ModuleSelector, public PlayersLocatorInterfaces
{
public:
/**
* Constructor.
* @param handler The module handler of the process.
* @param interfaces The paramters of the PlayersLocator module.
  */
  PlayersLocatorSelector(ModuleHandler &handler, const PlayersLocatorInterfaces& interfaces)
    : ModuleSelector(SolutionRequest::playersLocator),
    PlayersLocatorInterfaces(interfaces)
  {
    handler.setModuleSelector(SolutionRequest::playersLocator, this);
  }
  
  /** 
  * Is called on start and when the selected solution changes
  * to create a specific solution.
  * @param id The id of the solution to create
  * @return The created solution or 0
  */
  virtual Module* createSolution(SolutionRequest::ModuleSolutionID id)
  {
    switch(id)
    {
    case SolutionRequest::go2003PlayersLocator:
      return new GO2003PlayersLocator(*this);
    default:
      return 0;
    }
  }
};

#endif //__PlayersLocatorSelector_h_

/*
* Change log:
*
* $Log: PlayersLocatorSelector.h,v $
* Revision 1.1.1.1  2004/05/22 17:20:39  cvsadm
* created new repository GT2004_WM
*
* Revision 1.3  2004/03/08 01:07:16  roefer
* Interfaces should be const
*
* Revision 1.2  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.1  2003/10/06 14:10:15  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.4  2003/03/29 12:52:32  mkunz
* GO2003PlayersLocator added
*
* Revision 1.3  2003/02/27 10:06:59  schmidt
* Added three variants of a SensorFusionPlayersLocator.
*
* Revision 1.2  2002/09/12 12:24:09  juengel
* continued change of module/solution mechanisms
*
* Revision 1.1  2002/09/10 15:36:15  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.3  2002/06/07 10:16:37  kspiess
* constructor changed; team messages integration
*
* Revision 1.2  2002/05/14 12:39:04  dueffert
* corrected some documentation mistakes
*
* Revision 1.1.1.1  2002/05/10 12:40:15  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.3  2002/04/16 16:50:05  dueffert
* no message
*
* Revision 1.2  2002/04/12 07:08:55  juengel
* Player Specialist added.
*
* Revision 1.2  2002/04/02 13:10:20  dueffert
* big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
*
* Revision 1.1  2002/02/05 03:52:46  loetzsch
* added a few new module selectors
*
*/

