/**
* @file PlayersLocator.h
* 
* This file contains a generic class for Players-Localization.
*/

#ifndef __PlayersLocator_h_
#define __PlayersLocator_h_

#include "Tools/Module/Module.h"

#include "Representations/Perception/PlayersPercept.h"
#include "Representations/Cognition/RobotPose.h"
#include "Representations/WLan/TeamMessageCollection.h"
#include "Representations/Cognition/PlayerPoseCollection.h"
#include "Representations/Motion/OdometryData.h"

/**
* @class PlayersLocatorInterfaces
* 
* The interfaces of the PlayersLocator module.
*/
class PlayersLocatorInterfaces
{
public:
  /** Constructor.*/
  PlayersLocatorInterfaces(
    const PlayersPercept& playersPercept,
    const RobotPose& robotPose,
    const TeamMessageCollection& teamMessageCollection,
    const OdometryData& odometryData,
    PlayerPoseCollection& playerPoseCollection)
    : playersPercept(playersPercept),
    robotPose(robotPose),
    teamMessageCollection(teamMessageCollection),
    odometryData(odometryData),
    playerPoseCollection(playerPoseCollection)
  {}
  
protected:
  /** A detected player */
  const PlayersPercept& playersPercept;
  
  /** The estimated position of the robot */
  const RobotPose& robotPose;
  
  /** Team messages from the other robots */ 
  const TeamMessageCollection& teamMessageCollection;

  /** The odometry data that was calculated by the motion modules */
  const OdometryData& odometryData;
  
  /** The player positions to be calculated */
  PlayerPoseCollection& playerPoseCollection;

};

/**
* @class PlayersLocator 
*
* The Base class for player locators
*
* The locator for other players performs the calculation of the positions of
* the other players based on players percepts. In addition, positions of
* team mates received via the wireless network communication are integrated.
*/
class PlayersLocator : public Module, public PlayersLocatorInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the PlayersLocator module.
  */
  PlayersLocator(const PlayersLocatorInterfaces& interfaces)
    : PlayersLocatorInterfaces(interfaces)
  {}
  
  /** Destructor */
  virtual ~PlayersLocator() {}
};

#endif //__PlayersLocator_h_

/*
 * Change log :
 * 
 * $Log: PlayersLocator.h,v $
 * Revision 1.1.1.1  2004/05/22 17:20:39  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2004/03/08 01:07:16  roefer
 * Interfaces should be const
 *
 * Revision 1.1  2003/10/06 14:10:15  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 15:27:49  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.3  2002/09/17 23:55:21  loetzsch
 * - unraveled several datatypes
 * - changed the WATCH macro
 * - completed the process restructuring
 *
 * Revision 1.2  2002/09/12 12:24:09  juengel
 * continued change of module/solution mechanisms
 *
 * Revision 1.1  2002/09/10 15:36:15  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.4  2002/08/30 13:38:16  dueffert
 * removed unused includes
 *
 * Revision 1.3  2002/08/22 14:41:04  risler
 * added some doxygen comments
 *
 * Revision 1.2  2002/06/07 10:16:37  kspiess
 * constructor changed; team messages integration
 *
 * Revision 1.1.1.1  2002/05/10 12:40:15  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.5  2002/04/02 13:10:20  dueffert
 * big change: odometryData and cameraMatrix in image now, old logfiles may be obsolete
 *
 * Revision 1.4  2002/02/05 04:06:02  loetzsch
 * changed the execution of the PlayersLocator. Parameter
 * const PerceptCollection& perceptCollection became
 * const BallPercept& ballPercept.
 *
 * Revision 1.3  2001/12/21 14:09:39  roefer
 * Added several destructors
 *
 * Revision 1.2  2001/12/10 17:47:06  risler
 * change log added
 *
 */
