/**
* @file WakeUpEngine.h
* 
* Definition of class WakeUpEngine
*
* @author Andreas Heinze
*/

#ifndef __WakeUpEngine_h_
#define __WakeUpEngine_h_


#include "Representations/Perception/SensorDataBuffer.h"
#include "Representations/Motion/JointData.h"
#include "Representations/Motion/PIDData.h"

/** 
* @class WakeUpEngine
*
*
* 
*/
class WakeUpEngine
{
public:
/** 
* Constructor 
* @param interfaces The paramters of the MotionControl module.
* @param moduleHandler A reference to the ModuleHandler of the Process.
  */
  WakeUpEngine();
  
  /** Destructor */
  ~WakeUpEngine();
  
  

  bool execute(unsigned int frameNumber, const SensorData& sensorData, JointData& jointData, PIDData& pidData);
  
private:
  bool running;
  int counter;
  bool finished;
  unsigned long lastTimeRunFrameNumber;
  enum {numberOfKeyFrames = 4};
  long int position[JointData::numOfJoint][numberOfKeyFrames];
  long int stepSize[JointData::numOfJoint][numberOfKeyFrames-1];
  int frameNumberOfKeyFrame[numberOfKeyFrames];
  int frameNumberWhenDefaultPidDataIsReached;
  int currentKeyFrame;
  double diffP[JointData::numOfJoint];
  double diffI[JointData::numOfJoint];
  double diffD[JointData::numOfJoint];

  void start(const SensorData& sensorData, PIDData& pidData);
};

#endif// __WakeUpEngine_h_

/*
* Change log :
* 
* $Log: WakeUpEngine.h,v $
* Revision 1.2  2004/06/14 14:53:43  spranger
* put everything into execute (start is called from there)
* motioncontrol cleanup
*
* Revision 1.1.1.1  2004/05/22 17:20:37  cvsadm
* created new repository GT2004_WM
*
* Revision 1.3  2004/05/22 14:28:13  juengel
* First working version.
*
* Revision 1.2  2004/05/19 13:32:39  heinze
* worked at the engine
*
* Revision 1.1  2004/05/03 09:45:01  heinze
* Added WakeUpEngine.
*
*/
