/**
* @file MotionStabilizer.h
* 
* Definition of class MotionStabilizer
*
* @author Jan Hoffmann
*/

#ifndef __MotionStabilizer_h_
#define __MotionStabilizer_h_

#include "Modules/WalkingEngine/WalkingEngine.h"
#include "Tools/Math/PIDsmoothedValue.h"
#include "Representations/Perception/SensorDataBuffer.h"



/**
* @class MotionStabilizer
*
* class/function that tries to stabilize the robot in such a way that
* no forces other then gravity act on the center of mass (or wherever
* the acceleration sensor is placed). idea is to stabilize walking 
* movement of the robot. 
*
* @author Jan Hoffmann
*/

class MotionStabilizer
{
public:

  MotionStabilizer();

  /**
  * takes all parameters used to generate a motion and alters the joint
  * datas in order to stabilize the motion
  * 
  * @todo this is no parameter documentation!
  * @param lastMotionType
  * @param motionRequest
  * @param jointData
  * @param odometryData
  * @param sensorDataBuffer
  * 
  * @return true if successfull
  */ 
  bool stabilize(
    MotionRequest::MotionID lastMotionType,
    const MotionRequest& motionRequest, 
    JointData& jointData, 
    OdometryData& odometryData,
    const SensorDataBuffer& sensorDataBuffer);
  
  PIDsmoothedValue accelX, accelY, accelZ,
	  xFore, xHind, yLeft, yRight;

	double stabilizerScale;

private: 
};

#endif// __MotionStabilizer_h_

/*
 * Change log :
 * 
 * $Log: MotionStabilizer.h,v $
 * Revision 1.1.1.1  2004/05/22 17:20:37  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/10/06 14:10:13  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.2  2003/09/26 15:27:49  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.6  2003/06/13 17:05:43  jhoffman
 * largely simplified code
 *
 * Revision 1.5  2003/06/05 15:10:08  dueffert
 * doxygen bugs fixed
 *
 * Revision 1.4  2003/05/23 11:30:12  goehring
 * MotionStabilizer signature changed
 *
 * Revision 1.3  2003/05/23 09:36:51  goehring
 * MotionStabilizer gets all 4 Sensor Values
 *
 * Revision 1.2  2002/09/22 18:40:53  risler
 * added new math functions, removed GTMath library
 *
 * Revision 1.1  2002/09/10 15:36:15  cvsadm
 * Created new project GT2003 (M.L.)
 * - Cleaned up the /Src/DataTypes directory
 * - Removed challenge related source code
 * - Removed processing of incoming audio data
 * - Renamed AcousticMessage to SoundRequest
 *
 * Revision 1.2  2002/08/30 13:38:00  dueffert
 * removed unused includes
 *
 * Revision 1.1.1.1  2002/05/10 12:40:15  cvsadm
 * Moved GT2002 Project from ute to tamara.
 *
 * Revision 1.2  2002/04/25 14:50:36  kallnik
 * changed double/float to double
 * added several #include GTMath
 *
 * PLEASE use double
 *
 * Revision 1.1  2002/04/04 15:24:09  jhoffman
 * added motion stabilizer to motion control
 *
 *
 *
 */
