/**
* @file DefaultMotionControl.h
* 
* Definition of class DefaultMotionControl
*/

#ifndef __DefaultMotionControl_h_
#define __DefaultMotionControl_h_

#include "MotionControl.h"

#include "WakeUpEngine.h"

#include "MotionStabilizer.h"

#include "Modules/WalkingEngine/WalkingEngine.h"
#include "Modules/SpecialActions/SpecialActions.h"
#include "Modules/GetupEngine/GetupEngineSelector.h"

#include "Modules/WalkingEngine/InvKinWalkingEngine.h"

#include "Tools/Module/ModuleHandler.h"

/** 
* @class DefaultMotionControl
* 
* The default solution for the module MotionControl.
* Integrates head joint values from the head control, joint values from walking
* or special action engines and LED values from the LED control.
*/
class DefaultMotionControl : public MotionControl, public MotionStabilizer
{
public:
/** 
* Constructor 
* @param interfaces The paramters of the MotionControl module.
* @param moduleHandler A reference to the ModuleHandler of the Process.
  */
  DefaultMotionControl(ModuleHandler& moduleHandler,
    const MotionControlInterfaces& interfaces);
  
  /** Destructor */
  ~DefaultMotionControl();
  
  /** Executes the module */
  virtual void execute();
  
  /** 
  * Called from a MessageQueue to distribute messages.
  * Use message.getMessageID to decide if the message is relavant for 
  * the MesssageHandler derivate.
  * Use message.bin, message.text or message.config as In streams to get the data from.
  * @param message The message that can be read.
  * @return true if the message was read (handled).
  */
  virtual bool handleMessage(InMessage& message);
  
protected:
  /** determines the state of the MotionControl */
  void determineMotionControlState();

  /** sets the MotionControlState accordingly */
  void setMotionControlState();

  /** which module is currently used for calculation */
  // MotionRequest::MotionID currentMotionType;
  
  /** which module was used before */
  MotionRequest::MotionID lastMotionType;

  /** pointer to the WalkingEngine modules one for each walking type*/
  WalkingEngine *pWalkingEngine[WalkRequest::numOfWalkType];
  
  /** a pointer to the SpecialActions module */
  SpecialActions *pSpecialActions;
  
  /** a pointer to the GetupEngine module */
  GetupEngineSelector *pGetupEngine;
  
  /** 
  * a point to the single instance of the InvKinWalkingEngine
  * this is called by all different walk types using different parameter sets
  */
  InvKinWalkingEngine *pInvKinWalkingEngine;

  /** 
  * A reference to the ModuleHandler of the Process. 
  * Needed to create new solutions.
  */
  ModuleHandler& moduleHandler;

  /** counter used in wagTail */
  int tailCount;
  
  long lastHeadTilt, /**< Previous head tilt. */
       lastHeadPan, /**< Previous head pan. */
       lastHeadRoll; /**< Previous head roll. */

  /** executes the tail wag requested by motion request */
  void wagTail(
    const MotionRequest& motionRequest,
    const SensorData& sensorData,
    JointData& jointData
    );

  WakeUpEngine wakeUpEngine;
  // bool lastSpecialActionWasPlayDead;
  bool wakingUp;

  /** the last executed Motion indicated, that its possible to execute the motionRequest from Cognition */
  bool changeOfMotionControlStatePossible;

  /** the last cycle we were in */
  double positionInWalkCycle;

  /** The latest WalkRequest */
  WalkRequest latestWalkRequest;

  /** The latest SpecialActionRequest */
  SpecialActionRequest latestSpecialActionRequest;

  /** The state of the MotionControl */
  enum{
    stand,
    walk,
    specialAction,
    getup,
    wakeUp,
    playDead
  } motionControlState;
};

#endif// __DefaultMotionControl_h_

/*
* Change log :
* 
* $Log: DefaultMotionControl.h,v $
* Revision 1.7  2004/06/16 18:11:30  spranger
* bugfix
*
* Revision 1.6  2004/06/14 17:07:39  spranger
* removed breathe
*
* Revision 1.5  2004/06/14 15:05:52  spranger
* redone statemachine, changed some interfaces
*
* Revision 1.4  2004/06/07 18:50:09  spranger
* added positionInWalkCycle
*
* Revision 1.3  2004/06/02 17:19:31  spranger
* cleanup
*
* Revision 1.2  2004/05/26 16:10:24  dueffert
* better data types used
*
* Revision 1.1.1.1  2004/05/22 17:20:36  cvsadm
* created new repository GT2004_WM
*
* Revision 1.4  2004/05/03 09:51:18  heinze
* Prepared WakeUpEngine.
*
* Revision 1.3  2004/03/08 01:39:03  roefer
* Interfaces should be const
*
* Revision 1.2  2004/01/21 14:31:58  loetzsch
* Module Selectors create only the selected solution.
* When the solution changes, the old solution is erased and the new
* one ist created using createSolution(..)
*
* Revision 1.1  2003/10/06 14:10:13  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.1.1.1  2003/07/02 09:40:24  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.8  2003/04/27 07:49:35  roefer
* static vars -> member vars
*
* Revision 1.7  2003/01/23 16:44:10  risler
* only one instance of InvKinWalkingEngine
* parameter sets can now be switched while walking
* added UNSWFastTurn, combining two parameter sets
*
* Revision 1.6  2002/12/03 13:06:34  dueffert
* cleanup
*
* Revision 1.5  2002/11/26 13:08:05  jhoffman
* no message
*
* Revision 1.4  2002/11/25 14:49:07  jhoffman
* added "breathing" motion
*
* Revision 1.3  2002/09/22 18:40:53  risler
* added new math functions, removed GTMath library
*
* Revision 1.2  2002/09/11 00:06:58  loetzsch
* continued change of module/solution mechanisms
*
* Revision 1.1  2002/09/10 15:36:15  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.4  2002/09/03 16:00:50  juengel
* HeadControlMode follwTail, TailMode stayAsForced.
*
* Revision 1.3  2002/07/23 13:33:42  loetzsch
* new streaming classes
*
* removed many #include statements
*
* Revision 1.2  2002/06/04 16:44:55  risler
* tailRequest added
*
* Revision 1.1.1.1  2002/05/10 12:40:15  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.13  2002/04/29 13:48:24  risler
* added lastWalkType to WalkingEngine execute
*
* Revision 1.12  2002/04/26 13:35:33  risler
* DarmstadtGOWalkingEngine renamed to InvKinWalkingEngine
* added InvKinParameterSets
*
* Revision 1.11  2002/04/25 14:50:36  kallnik
* changed double/float to double
* added several #include GTMath
*
* PLEASE use double
*
* Revision 1.10  2002/04/04 15:14:40  jhoffman
* added motion stabilizer
*
* Revision 1.9  2002/04/04 15:07:59  rentmeister
* Walk with Ball hinzugefgt
*
* Revision 1.8  2002/04/03 16:44:31  jhoffman
* added "stabilizeRobot" to motionControl (which is turned off as a default)
*
* Revision 1.7  2002/02/28 16:28:25  risler
* added GT2001WalkingParameters
*
* Revision 1.6  2002/02/20 16:40:50  risler
* added GetupEngine
*
* Revision 1.5  2002/02/08 17:48:57  risler
* SensorData to MotionControl
*
* Revision 1.4  2002/01/19 12:42:32  risler
* fixed bug with solutionHandler
*
* Revision 1.3  2001/12/10 17:47:06  risler
* change log added
*
*/
