/**
* @file GT2004LEDControl.h
* 
* This file contains a class for LED Control.
*/

#ifndef __GT2004LEDControl_h_
#define __GT2004LEDControl_h_

#include "LEDControl.h"

/** the ATH LED control module for the German Open 2004*/
class GT2004LEDControl : public LEDControl
{
public:
/*
* Constructor.
* @param interfaces The paramters of the LEDControl module.
  */
  GT2004LEDControl(LEDControlInterfaces& interfaces);

  /** Executes the module. */
  virtual void execute();
  
private:
  void showWLANStatus();
  void showGameRelated();
  void showBatteryState();
  void showRequestedFaceLEDs();
  void showRequestedBackWhiteLEDs();
  void showRequestedBackColoredLEDs();
  void showRequestedHeadLEDs();
  void showMotionProcessFrameLostWarning();
  void showCognitionProcessFrameLostWarning();

  /** Internal call counter. */
  int executeCallCount; 

  int ledCode;

  unsigned long int lastMotionFrameNumber;

  enum Ers7LEDs
  {
    off = 0,
    headOrange       = 0x00000001,
      headWhite        = 0x00000002,
      modeRed          = 0x00000004,
      modeGreen        = 0x00000008, 
      modeBlue         = 0x00000010,
      wireless         = 0x00000020,
      face1            = 0x00000040,
      face2            = 0x00000080,
      face3            = 0x00000100,
      face4            = 0x00000200,
      face5            = 0x00000400,
      face6            = 0x00000800,
      face7            = 0x00001000,
      face8            = 0x00002000,
      face9            = 0x00004000,
      face10           = 0x00008000,
      face11           = 0x00010000,
      face12           = 0x00020000,
      face13           = 0x00040000,
      face14           = 0x00080000,
      backFrontBlue    = 0x00100000,
      backFrontWhite   = 0x00200000,
      backMiddleOrange = 0x00400000,
      backMiddleWhite  = 0x00800000,
      backRearRed      = 0x01000000,
      backRearWhite    = 0x02000000
  };
  
};

#endif// __GT2004LEDControl_h_

/*
 * Change log :
 * 
 * $Log: GT2004LEDControl.h,v $
 * Revision 1.3  2004/06/15 17:49:06  juengel
 * Added showMotionProcessFrameLostWarning() and showCognitionProcessFrameLostWarning.
 *
 * Revision 1.2  2004/06/09 07:46:34  juengel
 * Added showFrameLostWarning().
 *
 * Revision 1.1  2004/05/22 22:16:10  loetzsch
 * renamed ATH2004LEDControl to GT2004LEDControl
 *
 * Revision 1.1.1.1  2004/05/22 17:20:14  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.5  2004/03/25 21:20:31  juengel
 * Added head LEDs.
 *
 * Revision 1.4  2004/03/25 19:50:25  juengel
 * initialLedCodes are not used any more
 *
 * Revision 1.3  2004/03/21 19:08:15  juengel
 * Added back*White LED support.
 *
 * Revision 1.2  2004/03/20 17:17:59  juengel
 * no message
 *
 * Revision 1.1  2004/03/16 14:00:21  juengel
 * Integrated Improvments from "Gnne"
 * -ATH2004ERS7Behavior
 * -ATHHeadControl
 * -KickSelectionTable
 * -KickEditor
 *
 * Revision 1.1  2004/03/15 17:11:39  hoffmann
 * - added ATH2004HeadControl
 * - added ATH2004LEDControl
 * - headmotiontester shows "tilt2"
 * - motion process updates odometry while no new robotPose is received, added to motion request
 * - some ui adjustments
 * - added member function to "field" to find out if robot is in own penalty area for use in the obstacles locator
 *
 *
 */
