/**
* @file SLAMImageProcessorTools.h
*
* Tools and Definitons for SLAMImageProcessor
*
* @author Max Risler
* @author <a href="mailto:timlaue@tzi.de">Tim Laue</a>
*/

#ifndef __SLAMImageProcessorTools_h_
#define __SLAMImageProcessorTools_h_

// Uncomment to use it with ColorTable32K
//~ #define CT32K_LAYOUT

#ifdef CT32K_LAYOUT
#include "Representations/Perception/ColorTable32K.h"
#else
#include "Representations/Perception/ColorTable64.h"
#endif
#include "Modules/ImageProcessor/ImageProcessorTools/ColorCorrector.h"
#include "Tools/Math/Vector2.h"
#include "Tools/Math/Geometry.h"

#ifdef CT32K_LAYOUT
#define COLOR_CLASS(y,u,v) (colorClass)((ColorTable32K&) colorTable).colorClassesUnpacked[((y>>4)<<12)|((v>>2)<<6)|(u>>2)]
#define C(px, py, layer, value) colorCorrector.correct(px,py, layer, value)
#define CORRECTED_COLOR_CLASS(px,py,y,u,v) COLOR_CLASS(C(px, py, 0, y),C(px, py, 1, u),C(px, py, 2, v))
#else
// This is a hack to speed up color table access. It obviously only works with ColorTable64
#define COLOR_CLASS(y,u,v) (colorClass)((ColorTable64&) colorTable).colorClasses[(y) >> 2][(u) >> 2][(v) >> 2]
#define CORRECTED_COLOR_CLASS(px,py,y,u,v) (colorClass)((ColorTable64&) colorTable).colorClasses[colorCorrector.correct(px,py, 0, (y)) >> 2][colorCorrector.correct(px,py, 1, (u)) >> 2][colorCorrector.correct(px,py, 2, (v)) >> 2]
#endif

#endif // __SLAMImageProcessorTools_h_

/*
* $Log: SLAMImageProcessorTools.h,v $
* Revision 1.1  2004/07/02 10:11:47  nistico
* Cloned main image processor and created
* SpecialLandmarks specialist for SLAM challenge
*
*
*/
