/**
* @file SLAMEdgeSpecialist.h
* 
* This file contains a class for Image Processing.
* @author Dirk Thomas
*/

#ifndef __SLAMEdgeSpecialist_h_
#define __SLAMEdgeSpecialist_h_

#include "Representations/Perception/Image.h"
#include "Representations/Perception/LinesPercept.h"
#include "Representations/Perception/EdgesPercept.h"
#include "Tools/Math/Geometry.h"
#include "Tools/Math/Matrix2x2.h"

/**
The EdgeSpecialist finds a line- and border-edges in an image.
*/
class SLAMEdgeSpecialist  
{
public:
  SLAMEdgeSpecialist();

  /** reset all data before processing next frame. */
  void reset();

  /** reset before next scanline. */
  void resetLine();

  /** check point in camera-coordinates with given color on scanline if interesting changes. */
  void checkPoint(
    Vector2<int> point,
    colorClass color,
    const CameraMatrix& cameraMatrix,
    const CameraMatrix& prevCameraMatrix,
    const Image& image
  );

  /** add a point in camera-coordinates which is a candidate for an edge point. */
  void addCandidate(
    Vector2<int> point,
    const Image& image
  );

  /** Searches for the edges based on the points and return edge-percepts from those. */
  void getEdgesPercept(
    EdgesPercept& percept,
    const CameraMatrix& cameraMatrix,
    const CameraMatrix& prevCameraMatrix,
    const Image& image
  );

private:
  // used in checkPoint
  bool greenBefore;
  bool whiteBefore;
  int numberOfContinuousNoColor;
  Vector2<int> lastGreen, lastGreenField;
  Vector2<int> lastWhite, lastWhiteField;

  enum {maxNumberOfEdgePoints = 200};
  struct EdgePoint
  {
    Vector2<int> offset;
    Geometry::Line line;
    int weight;
    int belongsToLineNo;
  };
  EdgePoint edgePoints[maxNumberOfEdgePoints];
  int numOfEdgePoints; 
  double gradientThreshold;
  double normDistance;
  double normProjection;
  double multipleAverageDistance;
  Matrix2x2<double> referenceChange;
};

#endif// __EdgeSpecialist_h_

/*
* $Log: SLAMEdgeSpecialist.h,v $
* Revision 1.1  2004/07/02 10:11:47  nistico
* Cloned main image processor and created
* SpecialLandmarks specialist for SLAM challenge
*
*
*/
