
/** 
* @file SUSANEdgeDetectionLite.cpp
* Implementation of file SUSANEdgeDetectionLite.
*
* @author <A href=mailto:walter.nistico@uni-dortmund.de>Walter Nistico</A>
*/

#include "SUSANEdgeDetectionLite.h"

  SUSANEdgeDetectionLite::SUSANEdgeDetectionLite(int edgeThreshold)
  {
      setupSusanLUT(edgeThreshold);
  }
  
  SUSANEdgeDetectionLite::~SUSANEdgeDetectionLite(){};


  void SUSANEdgeDetectionLite::setupSusanLUT(int threshold) 
  {
    unsigned char temp;
    for (int k=127; k<255; k++) {
      temp = (unsigned char) (255*exp((double)(-pow(((k-126)<<1)/threshold,6))));
      Susan_LUT[k] = temp;
      Susan_LUT[254-k] = temp;
    }
  }


  bool SUSANEdgeDetectionLite::isEdgePoint(const Image& image, int posx, int posy, ColorSpectra channel) const
  {
    register int counter;
    register unsigned char center;
    unsigned char neighbours0;
    unsigned char neighbours1;
    unsigned char neighbours2;
    unsigned char neighbours3;
    unsigned char neighbours4;
    unsigned char neighbours5;
    unsigned char neighbours6;
    unsigned char neighbours7;
    
    int sp = static_cast<int> (channel);
    
    center = image.image[posy][sp][posx];          
    neighbours0 = image.image[posy-1][sp][posx];          
    neighbours1 = image.image[posy+1][sp][posx];          
    neighbours2 = image.image[posy][sp][posx-1];          
    neighbours3 = image.image[posy][sp][posx+1];          
    neighbours4 = image.image[posy-1][sp][posx-1];          
    neighbours5 = image.image[posy+1][sp][posx-1];          
    neighbours6 = image.image[posy-1][sp][posx+1];          
    neighbours7 = image.image[posy+1][sp][posx+1];          
    
    counter = correlation(neighbours0-center);
    counter += correlation(neighbours1-center);
    counter += correlation(neighbours2-center);
    counter += correlation(neighbours3-center);
    counter += correlation(neighbours4-center);
    counter += correlation(neighbours5-center);
    counter += correlation(neighbours6-center);
    counter += correlation(neighbours7-center);

    if (counter<GEOMETRIC_THRESHOLD)
      return true;
    else 
      return false;
  };
 
/*
* Change log :
* 
* $Log: SUSANEdgeDetectionLite.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:19:53  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2004/03/11 21:00:39  schmidtb
* removed errors with enums and destructor
*
* Revision 1.1  2004/03/03 13:43:51  nistico
* -Added SUSANEdgeDetectionLite
*
*
*
*/
