/** 
* @file LightingChangeTester.cpp
* Implementation of class LightingChangeTester.
*
* @author <A href=mailto:juengel@informatik.hu-berlin.de>Matthias Jngel</A>
*/

#include "LightingChangeTester.h"
#include "Tools/Debugging/Debugging.h"
#include "Tools/Math/Common.h"

LightingChangeTester::~LightingChangeTester()
{
}

LightingChangeTester::LightingChangeTester()
{
  init();
}

void LightingChangeTester::addColor(int channel1, int channel2, int channel3)
{
  accumulatedValueInImage[0] += channel1;
  accumulatedValueInImage[1] += channel2;
  accumulatedValueInImage[2] += channel3;
  numberOfMeasurementsInImage++;
}

void LightingChangeTester::init()
{
  numberOfImages = 0;
  numberOfMeasurementsInImage = 0;
  valuesOfLastImages[0].init();
  valuesOfLastImages[1].init();
  valuesOfLastImages[2].init();
}

void LightingChangeTester::startImage()
{
  numberOfMeasurementsInImage = 0;
  accumulatedValueInImage[0] = 0;
  accumulatedValueInImage[1] = 0;
  accumulatedValueInImage[2] = 0;
}

bool LightingChangeTester::lightingHasChanged()
{
  int valuesInCurrentImage[3];
  int averageOfLastValues[3];

  if(numberOfMeasurementsInImage == 0) return false;

  int channel;
  for(channel = 0; channel < 3; channel++)
  {
    valuesInCurrentImage[channel] = accumulatedValueInImage[channel] / numberOfMeasurementsInImage;
    valuesOfLastImages[channel].add(valuesInCurrentImage[channel]);
  }
  numberOfImages++;

  for(channel = 0; channel < 3; channel++)
  {
    averageOfLastValues[channel] = valuesOfLastImages[channel].getSum() / valuesOfLastImages[channel].getNumberOfEntries();
  }

//  {
//  OUTPUT(idText, text, "current: " << valuesInCurrentImage[0]);
//  OUTPUT(idText, text, averageOfLastValues[0]);
//  OUTPUT(idText, text, "y: " << abs(averageOfLastValues[0] - valuesInCurrentImage[0]) );
//  OUTPUT(idText, text, "u: " << abs(averageOfLastValues[1] - valuesInCurrentImage[1]) );
//  OUTPUT(idText, text, "v: " << abs(averageOfLastValues[2] - valuesInCurrentImage[2]) );
  if(
    (
    abs(averageOfLastValues[0] - valuesInCurrentImage[0]) > 60 ||
    abs(averageOfLastValues[1] - valuesInCurrentImage[1]) > 10 ||
    abs(averageOfLastValues[2] - valuesInCurrentImage[2]) > 10
    )
    && 
    numberOfImages > 1
    )
  {
    OUTPUT(idText, text, "change");
    OUTPUT(idText, text, "y: " << abs(averageOfLastValues[0] - valuesInCurrentImage[0]) );
    OUTPUT(idText, text, "u: " << abs(averageOfLastValues[1] - valuesInCurrentImage[1]) );
    OUTPUT(idText, text, "v: " << abs(averageOfLastValues[2] - valuesInCurrentImage[2]) );
    init();
    return true;
  }
  return false;
}



/*
 * Change log :
 * 
 * $Log: LightingChangeTester.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:19:51  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.1  2003/12/01 16:16:54  juengel
 * Added lighting change tester.
 *
 *
 */
