
/** 
* @file FastSUSANNoiseReduction.cpp
* Implementation of class FastSUSANNoiseReduction.
*
* @author <A href=mailto:walter.nistico@uni-dortmund.de>Walter Nistico</A>
*/

#include "FastSUSANNoiseReduction.h"

void FastSUSANNoiseReduction::setupSusanLUT(int threshold)
{
  int k;
  for (k=0; k<(threshold>>2); k++){
    Susan_LUT[63+k] = -1;
    Susan_LUT[63-k] = -1;
  }
  for (k=(threshold>>2); k<64; k++){
    Susan_LUT[63+k] = 0;
    Susan_LUT[63-k] = 0;
  }
}

void FastSUSANNoiseReduction::getFilteredImage(const Image& source, Image& destination) const
{
  destination.cameraInfo = source.cameraInfo;
  destination.colorTable = source.colorTable;
  destination.frameNumber = source.frameNumber;
  int width = source.cameraInfo.resolutionWidth;
  int height = source.cameraInfo.resolutionHeight;
  unsigned char A, B, C;
  for (int x=1; x<width-1; x++)
    for (int y=1; y<height-1; y++)
      {
        getFilteredPixel(source, x, y, A, B, C);
        destination.image[y][0][x] = A;
        destination.image[y][1][x] = B;
        destination.image[y][2][x] = C;
      }
}


/** Constructor */
FastSUSANNoiseReduction::FastSUSANNoiseReduction(const int smoothingThreshold)
{
  setupSusanLUT(smoothingThreshold);
}

/** Destructor */
FastSUSANNoiseReduction::~FastSUSANNoiseReduction()
{
}

/*
* Change log :
* 
* $Log: FastSUSANNoiseReduction.cpp,v $
* Revision 1.1.1.1  2004/05/22 17:19:48  cvsadm
* created new repository GT2004_WM
*
* Revision 1.4  2004/03/19 11:04:58  nistico
* Some corrections and restructuring
*
* Revision 1.3  2004/02/16 12:26:40  nistico
* Added noise reduction functionality for jpeg images in log file player
*
* Revision 1.2  2004/01/23 18:50:46  juengel
* Project GT2004 did not compile - fixed.
*
* Revision 1.1  2004/01/23 17:07:33  nistico
* Added FastSUSANNoiseReduction.*, a non-linear image noise reduction filter, to ImageProcessorTools
* Added debug visualization of segmented image in ColorTable32KImageProcessor, and experimental support of FastSUSANNoiseReduction
*
*
*/
