/** 
* @file ColorSpaceUsageCounter.cpp
* Implementation of class ColorSpaceUsageCounter.
*
* @author <A href=mailto:juengel@informatik.hu-berlin.de>Matthias Jngel</A>
*/

#include "ColorSpaceUsageCounter.h"
#include "Tools/Math/Histogram.h"

void ColorSpaceUsageCounter::generateImage
(
 const Image& image, 
 Image& resultImage) const
{
//  Histogram colorFrequencyHistogram(Histogram::colorFrequency);
  for (int y = 0; y < image.cameraInfo.resolutionHeight; y++) 
  {
    for (int x = 0; x < image.cameraInfo.resolutionWidth; x++) 
    {
      if(maxCount == 0) resultImage.image[y][0][x] = 0;
      else
      {
        resultImage.image[y][0][x] = 
          count[image.image[y][0][x]/16][image.image[y][1][x]/16][image.image[y][2][x]/16] * 255 / maxCount;
      }
      resultImage.image[y][1][x] = 127;
      resultImage.image[y][2][x] = 127;
/*      if(resultImage.image[y][0][x] < 80)
      {
        resultImage.image[y][0][x] = 0;
        resultImage.image[y][1][x] = 0;
        resultImage.image[y][2][x] = 0;
      }
*/
//      colorFrequencyHistogram.add(count[image.image[y][0][x]/16][image.image[y][1][x]/16][image.image[y][2][x]/16] * 255 / maxCount);
    }
  }
/*  for (y = 0; y < 64; y++)
  {
    for (u = 0; u < 64; u++)
    {
      for (v = 0; v < 64; v++)
      {
        if(count[y][u][v] != 0)
          colorFrequencyHistogram.add(count[y][u][v] * 255 / maxCount);
      }
    }
  }
  */
//  INFO(sendHistogram_colorFrequency, idHistogram, bin, colorFrequencyHistogram);
}

ColorSpaceUsageCounter::~ColorSpaceUsageCounter()
{
}

ColorSpaceUsageCounter::ColorSpaceUsageCounter()
{
  reset();
}

void ColorSpaceUsageCounter::addColor
(
 unsigned char y,
 unsigned char u,
 unsigned char v
 )
{
  y /= 16; u /= 16; v /= 16;

  count[y][u][v] += 1;
  if (count[y][u][v] > maxCount) maxCount = count[y][u][v];
}

void ColorSpaceUsageCounter::addColor
(
 unsigned char y,
 unsigned char u,
 unsigned char v,
 unsigned char range
 )
{
  y /= 16; u /= 16; v /= 16;

  if (y < range / 2) y = range / 2;
  if (u < range / 2) u = range / 2;
  if (v < range / 2) v = range / 2;

  if (y - range / 2 + range > 63) y = 63 + range / 2 - range;
  if (u - range / 2 + range > 63) u = 63 + range / 2 - range;
  if (v - range / 2 + range > 63) v = 63 + range / 2 - range;

  for(unsigned char currentY = y - range / 2; currentY < y - range / 2 + range; currentY++)
  {
    for(unsigned char currentU = u - range / 2; currentU < u - range / 2 + range; currentU++)
    {
      for(unsigned char currentV = v - range / 2; currentV < v - range / 2 + range; currentV++)
      {
        count[currentY][currentU][currentV] += 1;
        if (count[currentY][currentU][currentV] > maxCount) maxCount = count[currentY][currentU][currentV];
      }
    }
  }
}

bool ColorSpaceUsageCounter::isColorFrequent
(
 unsigned char y, 
 unsigned char u, 
 unsigned char v, 
 int threshold
 )
{
  if(maxCount == 0) return false;
  y /= 16; u /= 16; v /= 16;
  return count[y][u][v] * 100 / maxCount > threshold;
}

void ColorSpaceUsageCounter::reset()
{
  memset(count, 0, sizeof(count));
  maxCount = 0;
}

/*
 * Change log :
 * 
 * $Log: ColorSpaceUsageCounter.cpp,v $
 * Revision 1.1.1.1  2004/05/22 17:19:47  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.5  2003/12/15 11:46:14  juengel
 * Introduced CameraInfo
 *
 * Revision 1.4  2003/10/31 11:48:26  juengel
 * Replaced fixed image height and width.
 *
 * Revision 1.3  2003/10/30 18:30:19  juengel
 * Reduced number of cubes.
 *
 * Revision 1.2  2003/10/29 13:11:13  juengel
 * added methods "isColorFrequent" and "addColor(...,range)
 *
 * Revision 1.1  2003/10/23 07:15:17  juengel
 * Renamed ColorTableAuto to ColorTableReferenceColor,
 * added ColorTableCuboids.
 *
 *
 */
