/** 
* @file CircleCalculation.h
* Declaration of class CircleCalculation.
*
* @author <A href=mailto:juengel@informatik.hu-berlin.de>Matthias Jngel</A>
*/

#include "Tools/RingBufferWithSum.h"

#ifndef _CircleCalculation_h_
#define _CircleCalculation_h_

#include "Tools/Math/Geometry.h"
#include "Tools/Boundary.h"
#include "Tools/Debugging/DebugDrawings.h"

/**
* @class CircleCalculation
*
*
* @author <A href=mailto:juengel@informatik.hu-berlin.de>Matthias Jngel</A>
*/

#include "Tools/Math/Vector2.h"

class CircleCalculation
{
public:
/**
* The struct represents a ball point.
  */
  struct BallPoint : Vector2<int>
  {
    bool isBottom; /**< Is the point at the lower side of the ball? */
  };
  
  void init();
  
  bool createCircle(int set, Geometry::Circle& circle);
  void addBallPoint(int set, int x, int y, bool isBottom);
  int getNumberOfBallPoints(int set); 
  bool getBoundary(Boundary<int>& ballBoundary, int set);
  int paintBallPoints(
    int set, 
    int minIndex, 
    int drawingID,
    Drawings::Color color, 
    int size);
private:
  bool select3Points(int& point1, int& point2, int& point3, int set);
  
  Vector2<int> cutMiddlePerpendiculars(
    Vector2<int>& v1,
    Vector2<int>& v2,
    Vector2<int>& v3) const;
  
  enum {maxNumberOfBallPoints = 400}; /**< The maximum number of ball points. */
  
  enum {numberOfBallPointSets = 2}; /**< The number of ball point sets */
  
  BallPoint ballPoints[maxNumberOfBallPoints][numberOfBallPointSets]; /**< All sets of ball points. */
  int numberOfBallPoints[numberOfBallPointSets]; /**< The number of ball points in each set. */
};

#endif   //  _CircleCalculation_h_

/*
* Change log :
* 
* $Log: CircleCalculation.h,v $
* Revision 1.1.1.1  2004/05/22 17:19:46  cvsadm
* created new repository GT2004_WM
*
* Revision 1.3  2004/02/12 14:40:35  juengel
* changed visualzation.
*
* Revision 1.2  2003/12/15 11:46:14  juengel
* Introduced CameraInfo
*
* Revision 1.1  2003/12/04 09:44:23  juengel
* Added CircleCalculation
*
*
*/
