/** 
* @file GT2004HeadControlSymbols.h
*
* Declaration of class GT2004HeadControlSymbols.
*
* @author Martin Ltzsch
*/

#ifndef __GT2004HeadControlSymbols_h_
#define __GT2004HeadControlSymbols_h_

#include "../HeadControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

// prototype to avoid inclusion of GT2004HeadControl.h
class GT2004HeadControl;

// prototype to avoid inclusion of GT2004HeadControlBasicBehavior.h
class GT2004BasicBehaviorDirectedScanForLandmarks;

/**
* The Xabsl2 symbols that are defined in "symbols.xml"
*
* @author Martin Ltzsch
*/ 
class GT2004HeadControlSymbols : public Xabsl2FunctionProvider, public HeadControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the HeadControl module.
* @param headControl A reference to the HeadControl module
  */
  GT2004HeadControlSymbols(const HeadControlInterfaces& interfaces, 
    GT2004HeadControl& headControl,
    GT2004BasicBehaviorDirectedScanForLandmarks& gt2004BasicBehaviorDirectedScanForLandmarks);

  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
    /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  double getPositionInWalkCycle(); /*!< A function for the symbol "position-in-walk-cycle" */
  double getBallTimeSinceLastSeen(); /*!< A function for the symbol "ball.time-since-last-seen" */
  double getTimeSinceLastSeenConsecutively(); /*!< A function for the symbol "ball.time-since-last-seen-consecutively" */
  double getBallConsecutivelySeenTime(); /*!< A function for the symbol "ball.consecutive-seen-time" */
  double getCommunicatedBallDistance(); /*!< A function for the symbol "ball.communicated-ball-distance" */
  double getRelativeBallSpeedX(); /*!< A function for the symbol "ball.relative-speed-x" */
  double getRelativeBallSpeedY(); /*!< A function for the symbol "ball.relative-speed-y" */
  double getBallSpeedAbs(); /*!< A function for the symbol "ball.speed-abs" */
  double getSeenDistance(); /*!< A function for the symbol "ball.seen.distance" */
  double getTimeSinceLastSeenABeacon(); /*!< A function for the symbol "time-since-last-seen-beacon" */
  double getTimeBetweenSeen2LastBeacons(); /*!< A function for the symbol "time-between-last-beacons" */
  bool getBodyPSDDetectBall(); /*!< A function for the symbol "body-PSD-detect-ball" */
  bool getLastHeadPathIsFinished(); /*!< A function for the symbol "last-head-path-is-finished" */
  bool getSetJointsIsCloseToDestination(); /*!< A function for the symbol "set-joints-is-close-to-destination" */
  bool getSetJointsMaxPanReached(); /*!< A function for the symbol "set-joints-max-pan-reached" */
  bool getNextLandmarkIsWithinReach(); /*!< A function for the symbol "next-landmark-is-within-reach" */
  bool getReleasingBallLeftIsPossible(); /*!< A function for the symbol "releasing-ball-left-is-possible" */
  bool getReleasingBallRightIsPossible(); /*!< A function for the symbol "releasing-ball-right-is-possible" */
  //!@}

private:
  /** A reference to the HeadControl module */
  GT2004HeadControl& headControl;
  GT2004BasicBehaviorDirectedScanForLandmarks& gt2004BasicBehaviorDirectedScanForLandmarks;
  
  int lastSeenBeaconIndex;
};


#endif // __GT2004HeadControlSymbols_h_

/*
* Change Log
* 
* $Log: GT2004HeadControlSymbols.h,v $
* Revision 1.14  2004/06/28 09:46:57  dassler
* introduced some more headcontrol symbols
* time-since-last-seen-beacon
* time-between-last-beacons
*
* Revision 1.13  2004/06/27 15:37:45  dassler
* introduced ball speed to headcontrol
*
* Revision 1.12  2004/06/23 17:31:46  loetzsch
* improved
*
* Revision 1.11  2004/06/23 12:46:40  loetzsch
* added "ball.time-since-last-seen-consecutively"
*
* Revision 1.10  2004/06/18 18:28:39  dassler
* introduced basic-behavior:
* BeginBallSearchAtBallPositionSeen
* BeginBallSearchAtBallPositionCommunicated
* BeginBallSearchAtBallPositionPropagated
*
* track-ball modified and build in ball-just-lost
*
* Revision 1.9  2004/06/16 18:14:00  jhoffman
* - search-for-landmarks-bug removed (setjointsdirect now sets "headPathPlanner.last...")
*
* Revision 1.8  2004/06/15 16:29:56  jhoffman
* check in for practice match
*
* Revision 1.7  2004/06/14 20:12:10  jhoffman
* - numerous changes and additions to headcontrol
* - cameraInfo default constructor now creates ERS7 info
* - debug drawing "headcontrolfield" added
*
* Revision 1.6  2004/06/11 16:31:59  juengel
* Added symbol positionInWalkCycle.
*
* Revision 1.5  2004/05/26 12:25:24  juengel
* Added release-ball modes.
*
* Revision 1.4  2004/05/25 13:12:06  tim
* changed body PSD stuff
*
* Revision 1.3  2004/05/25 10:29:49  tim
* added body PSD symbols
*
* Revision 1.2  2004/05/23 20:27:57  loetzsch
* some improvements with the head control
*
* Revision 1.1.1.1  2004/05/22 17:19:24  cvsadm
* created new repository GT2004_WM
*
* Revision 1.1  2004/05/18 13:40:00  loetzsch
* registered symbols and basic behaviors for GT2004HeadControl,
* renamed some states and basic behaviors
*
*/

