/**
* @file DefaultGetupEngine.h
* 
* Definition of class DefaultGetupEngine
* 
* @author Max Risler
*/

#ifndef __DefaultGetupEngine_h__
#define __DefaultGetupEngine_h__

#include "GetupEngine.h"
#include "Tools/Actorics/JointDataSequencer.h"

/** angles above which getup engine will take action
* @attention adjust the angles to values in SensorDataProcessor
*/
const double defaultGetupEngineFalldownTiltAngle = fromDegrees(50);
const double defaultGetupEngineFalldownRollAngle = fromDegrees(35);
const double defaultGetupEngineRollOnWallAngle = fromDegrees(17);

const double defaultGetupEngineFalldownTiltAngle7 = fromDegrees(50);
const double defaultGetupEngineFalldownTiltAngleBack7 = fromDegrees(-20);
const double defaultGetupEngineFalldownRollAngle7 = fromDegrees(35);
const double defaultGetupEngineRollOnWallAngle7 = fromDegrees(20);

/**
* The default getup engine.
*
* It executes different JointDataSequences for different body roll angles.
* Body roll angle is determined by current acceleration sensor values.
*/
class DefaultGetupEngine : public GetupEngine
{
public:
  /** Constructor */
  DefaultGetupEngine(const GetupEngineInterfaces& interfaces);
  
  /** Executes the engine */
  virtual bool executeParameterized(JointData& jointData);
  
protected:
  
  /** the JointDataSequencer */
  JointDataSequencer sequencer;
  
  /** current state */
  enum {
    unknown,
      leftSideDown,
      rightSideDown,
      getupFromUpright,
      standing,
      rollRight,
      rollLeft,
	  //makeRoll,  
	  //sittingUpright,
      numOfStates
  } state,lastState;


  /** current state for ERS 7*/
 /* enum {
      unknown7,
      leftSideDown7,
      rightSideDown7,
      getupFromUpright7,
      standing7,
	  makeRoll7,  
	  sittingUpright7,
      numOfStates7
  } stateERS7,lastStateERS7;
  
*/
  /** joint data sequence executed in each state */
  JointDataSequence sequence[numOfStates];
  
   /** joint data sequence executed in each state for ERS 7 */
  JointDataSequence sequenceERS7[numOfStates];

  unsigned long stateStartTime;
  unsigned long lastGetupTime;
  int countTry;
};

#endif // __DefaultGetupEngine_h__

/*
* Change log :
* 
* $Log: DefaultGetupEngine.h,v $
* Revision 1.1.1.1  2004/05/22 17:19:10  cvsadm
* created new repository GT2004_WM
*
* Revision 1.10  2004/04/09 11:35:51  roefer
* Bremen Byters German Open check-in
*
* Revision 1.9  2004/04/08 15:33:05  wachter
* GT04 checkin of Microsoft-Hellounds
*
* Revision 1.8  2004/03/08 01:38:52  roefer
* Interfaces should be const
*
* Revision 1.7  2004/02/29 14:57:37  roefer
* Removed static variable, initialized state, added support for robot with broken acceleration sensors
*
* Revision 1.6  2004/02/27 20:32:09  brueckne
* comment by heinze: getup-engine works for all common cases, specials aren't included yet
*
* Revision 1.5  2004/02/27 17:15:40  heinze
* improved getup-behavior for ERS7
*
* Revision 1.4  2004/02/26 11:47:28  heinze
* bug removed
*
* Revision 1.3  2004/02/26 10:55:43  heinze
* added states to enum for ERS7
*
* Revision 1.2  2004/02/25 16:03:51  heinze
* added/began getup-motion for ERS7
*
* Revision 1.1  2003/10/06 14:10:14  cvsadm
* Created GT2004 (M.J.)
*
* Revision 1.2  2003/09/26 11:38:51  juengel
* - sorted tools
* - clean-up in DataTypes
*
* Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
* created new repository for the competitions in Padova from the 
* tamara CVS (Tuesday 2:00 pm)
*
* removed unused solutions
*
* Revision 1.7  2003/06/20 15:32:32  dueffert
* getting from down from wall by rolling added
*
* Revision 1.6  2003/06/19 15:53:40  dueffert
* rolling if stuck added, beautified
*
* Revision 1.5  2003/06/18 18:12:11  dueffert
* getup stuck recognition added
*
* Revision 1.4  2003/03/06 12:05:43  dueffert
* execute with parameters renamed to avoid inheritance warnings
*
* Revision 1.3  2002/09/22 18:40:53  risler
* added new math functions, removed GTMath library
*
* Revision 1.2  2002/09/11 00:06:58  loetzsch
* continued change of module/solution mechanisms
*
* Revision 1.1  2002/09/10 15:36:14  cvsadm
* Created new project GT2003 (M.L.)
* - Cleaned up the /Src/DataTypes directory
* - Removed challenge related source code
* - Removed processing of incoming audio data
* - Renamed AcousticMessage to SoundRequest
*
* Revision 1.2  2002/08/22 14:41:04  risler
* added some doxygen comments
*
* Revision 1.1.1.1  2002/05/10 12:40:14  cvsadm
* Moved GT2002 Project from ute to tamara.
*
* Revision 1.4  2002/04/17 17:04:41  risler
* Darmstadt GO
*
* Revision 1.3  2002/02/23 17:07:22  risler
* code cleaned up
*
* Revision 1.2  2002/02/23 16:33:07  risler
* finished GetupEngine
*
* Revision 1.1  2002/02/20 16:40:50  risler
* added GetupEngine
*
*
*/
