/**
* @file ColorTableModSelector.h
*
* Definition of class ColorTableModSelector
*
* @author <A href=mailto:walter.nistico@uni-dortmund.de>Walter Nistico</A>
*/

#ifndef __ColorTableModSelector_h_
#define __ColorTableModSelector_h_

#include "Tools/Module/ModuleSelector.h"

#include "ColorTable64Mod.h"
#include "ColorTableTSLMod.h"
#include "ColorTable32KMod.h"

/**
* A selector for color table modules.
*/
class ColorTableModSelector : public ModuleSelector, public ColorTableModInterfaces
{
public:
/**
* Constructor.
* @param handler The module handler of the process.
* @param interfaces The parameters of the ImageProcessor module.
*/
  ColorTableModSelector(ModuleHandler &handler, const ColorTableModInterfaces& interfaces)
    : ModuleSelector(SolutionRequest::colorTableMod), ColorTableModInterfaces(interfaces)
  {
    handler.setModuleSelector(SolutionRequest::colorTableMod, this);
  }

  /** 
  * Is called on start and when the selected solution changes
  * to create a specific solution.
  * @param id The id of the solution to create
  * @return The created solution or 0
  */
  virtual Module* createSolution(SolutionRequest::ModuleSolutionID id)
  {
    switch(id)
    {
    case SolutionRequest::colorTable64Mod:
      {
        ColorTable64Mod* _colorTable64Mod = new ColorTable64Mod(*this);
        _colorTable64Mod->setup();
        return _colorTable64Mod;
      }
    case SolutionRequest::colorTableTSLMod:
      {
        ColorTableTSLMod* _colorTableTSLMod = new ColorTableTSLMod(*this);
        _colorTableTSLMod->setup();
        return _colorTableTSLMod;
      }
    case SolutionRequest::colorTable32KMod:
      {
        ColorTable32KMod* _colorTable32KMod = new ColorTable32KMod(*this);
        _colorTable32KMod->setup();
        return _colorTable32KMod;
      }
    default:
      {
        ColorTable* dummy = new ColorTable();
        memcpy(colorTable, dummy, sizeof(ColorTable));
        delete(dummy);
        return 0;
      }
    }
  }
  
};

#endif // __ColorTableModSelector_h_

/*
* Change log :
* 
* $Log: ColorTableModSelector.h,v $
* Revision 1.2  2004/05/27 10:25:18  loetzsch
* removed all prepocessor directives NO_COLOR_TABLE_SELECTOR
*
* Revision 1.1.1.1  2004/05/22 17:19:08  cvsadm
* created new repository GT2004_WM
*
* Revision 1.3  2004/03/08 01:38:51  roefer
* Interfaces should be const
*
* Revision 1.2  2004/02/16 16:23:48  dueffert
* actively disable ColorTableMod to have an empty but initialized colorTable
*
* Revision 1.1  2004/01/30 15:44:34  nistico
* Created a Color Table Selector, which permits to switch color tables at run time using the same image processor.
* If your image processor was designed to use only ColorTable64, leave it as the default choice and you should
* (hopefully) have no problems.
* In case of trouble, i put a conditional compilation switch in SolutionRequest.h, simply uncomment the definition of NO_COLOR_TABLE_SELECTOR; in that case, the code should get back to the original solution, but the coltable which will be looked upon first for loading will be ColorTable64 (as it's the default solution), so there's no reason anymore to remove the other color tables from the CVS.
*
*
*/
