/**
* @file ColorTableMod.h
* Declaration of class ColorTableModInterfaces and ColorTableModInterfaces.
*
* @author <A href=mailto:walter.nistico@uni-dortmund.de>Walter Nistico</A>
*/

#ifndef _ColorTableMod_h_
#define _ColorTableMod_h_

#include "Tools/Module/Module.h"
#include "Representations/Perception/ColorTable.h"

/**
* @class ColorTableModInterfaces
*
* The interface used by ColorTableMod ("Monsieur De Lapalisse" :)
*/
class ColorTableModInterfaces
{
public:
  /** Constructor */
  ColorTableModInterfaces (ColorTable& colorTable)
    : colorTable(&colorTable)
  {}
  
  /** Pointer to the colorTable accessed by image processors */
  ColorTable* colorTable;
};


/**
* @class ColorTableMod
*
* Base class of color table modules, used to load and switch color tables at runtime
*/
class ColorTableMod : public Module, public ColorTableModInterfaces
{
public:
  /** Constructor */
  ColorTableMod(const ColorTableModInterfaces& interfaces)
    : ColorTableModInterfaces(interfaces)
  {}
  
  /** This function loads the colortable from storage and instantiates it*/
  virtual void setup() = 0;
  
  /** Destructor */
  virtual ~ColorTableMod() {}
  
};

#endif   //  _ColorTableMod_h_

/*
* Change log :
*
* $Log: ColorTableMod.h,v $
* Revision 1.1.1.1  2004/05/22 17:19:08  cvsadm
* created new repository GT2004_WM
*
* Revision 1.3  2004/03/08 01:38:51  roefer
* Interfaces should be const
*
* Revision 1.2  2004/02/29 13:37:15  dueffert
* doxygen bugs fixed and beautified
*
* Revision 1.1  2004/01/30 15:44:34  nistico
* Created a Color Table Selector, which permits to switch color tables at run time using the same image processor.
* If your image processor was designed to use only ColorTable64, leave it as the default choice and you should
* (hopefully) have no problems.
* In case of trouble, i put a conditional compilation switch in SolutionRequest.h, simply uncomment the definition of NO_COLOR_TABLE_SELECTOR; in that case, the code should get back to the original solution, but the coltable which will be looked upon first for loading will be ColorTable64 (as it's the default solution), so there's no reason anymore to remove the other color tables from the CVS.
*
*
*/
