/** 
* @file ColorTable64Mod.cpp
* Implementation of class ColorTable64Mod.
*
* @author <A href=mailto:walter.nistico@uni-dortmund.de>Walter Nistico</A>
*/

#include "ColorTable64Mod.h"
#include "Tools/Location.h"

/* 
I don't like this.
Directly copying an object to a memory buffer is a C-style low level way of instantiating it, 
beside, the initialization of the memory buffer looks quite ugly because of the test operators
to determine the size of the biggest colortable object, and it gets worser and worser as new
colortables are implemented.
I have a more elegant solution which gives access to colortables to the image processors 
through a colortable pointer: it works, but it needed a thorough rewriting of the image processor
interface, and it has a potential for problems with image processors designed to use a 
single color table (ColorTable64) such as GridImageProcessor2.
If you want to support this second approach, please write me an e-mail.
*/
void ColorTable64Mod::setup()
{
  ColorTable64* colorTable64 = new ColorTable64();
  InBinaryFile stream(getLocation().getModelFilename("coltable.c64"));
  colorTable64->setFormat(ColorTable64::CT64);
  if (stream.exists())
  {
    stream >> *colorTable64;
  }
  memcpy(colorTable, colorTable64, sizeof(ColorTable64));
  delete colorTable64;
}

/*
* Change log :
* 
* $Log: ColorTable64Mod.cpp,v $
* Revision 1.3  2004/06/27 17:04:42  nistico
* ColorTableMod works again, now ColorTable32K are converted when selected
* into ColorTable64 format, and can be selected at runtime what to use.
*
* Revision 1.2  2004/05/27 10:08:08  thomas
* added model-specific locations
*
* Revision 1.1.1.1  2004/05/22 17:19:08  cvsadm
* created new repository GT2004_WM
*
* Revision 1.1  2004/01/30 15:44:34  nistico
* Created a Color Table Selector, which permits to switch color tables at run time using the same image processor.
* If your image processor was designed to use only ColorTable64, leave it as the default choice and you should
* (hopefully) have no problems.
* In case of trouble, i put a conditional compilation switch in SolutionRequest.h, simply uncomment the definition of NO_COLOR_TABLE_SELECTOR; in that case, the code should get back to the original solution, but the coltable which will be looked upon first for loading will be ColorTable64 (as it's the default solution), so there's no reason anymore to remove the other color tables from the CVS.
*
*
*/
