/** 
* @file ColorTable32KMod.h
* Declaration of class ColorTable32KMod.
*
* @author <A href=mailto:walter.nistico@uni-dortmund.de>Walter Nistico</A>
*/

#ifndef _ColorTable32KMod_h_
#define _ColorTable32KMod_h_

#include "ColorTableMod.h"
#include "Representations/Perception/ColorTable64.h"
#include "Tools/Streams/InOut.h"

/**
* @class ColorTable32KMod
*
* This class is a wrapper used by ColorTableModSelector to load and instantiate 
* a colormap of type ColorTable32K. 
*
* @author <A href=mailto:walter.nistico@uni-dortmund.de>Walter Nistico</A>
*/
class ColorTable32KMod : public ColorTableMod
{
public:

  /** Constructor */
  ColorTable32KMod(const ColorTableModInterfaces& interfaces)
  : ColorTableMod(interfaces)
  {}
  
  /**
  * Loads and instantiates this kind of colormap by copying it back to the 
  *  main colorTable buffer */
  void setup();

  /** this method does nothing here, it's just required by the Module interface */
  void execute() {};
  
};

#endif

/*
* Change log :
* 
* $Log: ColorTable32KMod.h,v $
* Revision 1.2  2004/06/27 17:04:42  nistico
* ColorTableMod works again, now ColorTable32K are converted when selected
* into ColorTable64 format, and can be selected at runtime what to use.
*
* Revision 1.1.1.1  2004/05/22 17:19:08  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2004/03/08 01:38:50  roefer
* Interfaces should be const
*
* Revision 1.1  2004/01/30 15:44:34  nistico
* Created a Color Table Selector, which permits to switch color tables at run time using the same image processor.
* If your image processor was designed to use only ColorTable64, leave it as the default choice and you should
* (hopefully) have no problems.
* In case of trouble, i put a conditional compilation switch in SolutionRequest.h, simply uncomment the definition of NO_COLOR_TABLE_SELECTOR; in that case, the code should get back to the original solution, but the coltable which will be looked upon first for loading will be ColorTable64 (as it's the default solution), so there's no reason anymore to remove the other color tables from the CVS.
*
*
*/
