/** 
* @file CollisionDetector.h
*
* This file contains a generic class for collision detection.
*
* @author Daniel Ghring
*/

#ifndef __CollisionDetector_h_
#define __CollisionDetector_h_


#include "Tools/Module/Module.h"

#include "Representations/Perception/SensorDataBuffer.h"
#include "Representations/Perception/CollisionPercept.h"
#include "Representations/Motion/MotionInfo.h"

/**
* @class CollisionDetectorInterfaces
* 
* The interfaces of the CollisionDetector module.
*/
class CollisionDetectorInterfaces
{
public:
  /** Constructor. */
  CollisionDetectorInterfaces(
    const SensorDataBuffer& sensorDataBuffer,
    const MotionInfo& motionInfo,
    CollisionPercept& collisionPercept)
    : sensorDataBuffer(sensorDataBuffer),
    motionInfo(motionInfo),
    collisionPercept(collisionPercept)
  {	
  }

  /** The SensorDataBuffer */
  const SensorDataBuffer& sensorDataBuffer;

  /** The motions that are executed by the Motion process */
  const MotionInfo& motionInfo;

  /** The JointState to be generated */
  CollisionPercept& collisionPercept;
};


/**
* @class CollisionDetector 
*
* The base class for collision detectors
*
* @author Daniel Ghring
*/
class CollisionDetector : public Module, public CollisionDetectorInterfaces
{
public:
/*
* Constructor.
* @param interfaces The paramters of the CollisionDetector module.
  */
  CollisionDetector(const CollisionDetectorInterfaces& interfaces)
    : CollisionDetectorInterfaces(interfaces)
  {}
  
  /** Destructor */
  virtual ~CollisionDetector() {}
};

#endif // __CollisionDetector_h_

/*
 * Change log :
 * 
 * $Log: CollisionDetector.h,v $
 * Revision 1.2  2004/05/27 09:09:19  loetzsch
 * clean up in the interfaces
 *
 * Revision 1.1.1.1  2004/05/22 17:19:06  cvsadm
 * created new repository GT2004_WM
 *
 * Revision 1.2  2004/03/08 01:38:48  roefer
 * Interfaces should be const
 *
 * Revision 1.1  2003/10/06 14:10:14  cvsadm
 * Created GT2004 (M.J.)
 *
 * Revision 1.3  2003/09/26 21:23:20  loetzsch
 * renamed class JointState to CollisionPercept
 *
 * Revision 1.2  2003/09/26 15:27:49  juengel
 * Renamed DataTypes to representations.
 *
 * Revision 1.1.1.1  2003/07/02 09:40:23  cvsadm
 * created new repository for the competitions in Padova from the 
 * tamara CVS (Tuesday 2:00 pm)
 *
 * removed unused solutions
 *
 * Revision 1.5  2003/06/20 20:20:43  goehring
 * ExecutedMotionReques instead of MotionRequest implemented
 *
 * Revision 1.4  2003/05/23 09:31:59  goehring
 * CollisionDetector - Interface extended to MotionRequest
 *
 * Revision 1.3  2003/05/13 12:33:11  goehring
 * Revised
 *
 * Revision 1.2  2003/05/02 18:26:17  risler
 * SensorDataBuffer added
 * replaced SensorData with SensorDataBuffer
 * full SensorData resolution now accessible
 *
 * Revision 1.1  2003/04/25 19:48:08  goehring
 * Added new module CollisionDetector
 *
 * 
 */
