/** 
* @file OpenChallengeSymbols.h
*
* Declaration of class BallSymbols.
*
* @author 
*/

#ifndef __OpenChallengeSymbols_h_
#define __OpenChallengeSymbols_h_

#include "../../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"


typedef struct OC
{
  double type;
  double x;
  double y;
  double rotation;
} OC;

class OpenChallengeSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:

  enum OCStatus
  {
    initial = 0,
    intro,
    goToBridge,
    goToBitePoint,
    allBitePointsReady,
    walkWithBridge,
    extro,
    finished
  };

  enum OCSetStatus
  {
    setInitial = 0,
    setIntro,
    setGoToBridge,
    setGoToBitePoint,
    setMyBitePointIsReady,
    setLostMyBitePoint,
    setWalkWithBridge,
    setExtro,
    setFinished
  };

/*
* Constructor.
* @param interfaces The parameters of the BehaviorControl module.
  */
  OpenChallengeSymbols(const BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);

  /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  OCBridge::Side getLastSeenSide();    /*!< A function for the symbol "bridge.last-seen-side" */
  double getSeenDistanceToBridge();    /*!< A function for the symbol "bridge.seen.distance" */
  double getSeenAngleToBridge();       /*!< A function for the symbol "bridge.seen.angle" */
  double getTimeSinceLastSeenBridge(); /*!< A function for the symbol "bridge.time-since-last-seen" */

  BitePoint::Position getBitePointPosition(); /*!< A function for the symbol "bite-point.position" */
  double getSeenDistanceToBitePoint();        /*!< A function for the symbol "bite-point.seen.distance" */
  double getSeenAngleToBitePoint();           /*!< A function for the symbol "bite-point.seen.angle" */
  double getPreciseShiftToBitePoint();        /*!< A function for the symbol "bite-point.precise-shift" */
  double getTimeSinceLastSeenBitePoint();     /*!< A function for the symbol "bite-point.time-since-last-seen" */

  double redLineInImageAngle();
  double redLineAngle();
  double getTimeSinceLastSeenRedLine();     /*!< A function for the symbol "bite-point.time-since-last-seen" */
  double getSeenDistanceToRedLine();    /*!< A function for the symbol "bridge.seen.distance" */
  
  
  //!@}


  /** Varaible to hold the open challenge status */
  OCStatus ocStatus;

  /* A function for the output symbol "open-challenge.set-status". */
  void setOCStatus(int aStatus);


private:
  OC m_walkRequest;
  double m_headrot;

  int bitePointToUse[Player::numOfPlayerNumbers];
  bool bitePointReady[BitePoint::numOfPositions];
  int masterDog;

};




#endif // OpenChallengeSymbols

/*
* Change Log
* 
* $Log: OpenChallengeSymbols.h,v $
* Revision 1.2  2004/06/01 13:58:14  schumann
* special percept type redLine added,
* part 1 of open challenge added
*
* Revision 1.1.1.1  2004/05/22 17:18:04  cvsadm
* created new repository GT2004_WM
*
* Revision 1.4  2004/05/17 18:20:00  kerdels
* adjusted symbols for open challenge to enable free mapping of players to bitePoints- and controllerpositions
*
* Revision 1.3  2004/05/17 17:17:50  kerdels
* added symbols for the sequence control of the open challenge,
* fixed a bug concerning 5-dog-mode and distribution of option-ratings,
* set one = 0 in enum Player::playerNumber --> just to be sure ;-)
*
* Revision 1.2  2004/05/17 01:56:15  kerdels
* prepared some symbols for the open challenge bridge detection
*
* Revision 1.1  2004/05/08 16:18:14  hamerla
* Open Challenge
*
*
*/

