/** 
* @file GT2004StrategySymbols.h
*
* Declaration of class GT2004StrategySymbols.
*
* @author Martin Ltzsch
*/

#ifndef __GT2004StrategySymbols_h_
#define __GT2004StrategySymbols_h_

#include "../../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"
#include "Tools/Streams/InStreams.h"
#include "Tools/Streams/OutStreams.h"

/**
* The Xabsl2 symbols that are defined in "strategy-symbols.xml"
*
* @author Martin Ltzsch
*/ 
class GT2004StrategySymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
  /*
  * Constructor.
  * @param interfaces The paramters of the BehaviorControl module.
  */
  GT2004StrategySymbols(BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);
  
  /** updates the symbols */
  void update();

  /** current estimated time to reach the ball */
  double estimatedTimeToReachBall;

  /** computes the estimated time to reach the ball */
  void estimateTimeToReachBall();

  /** current role */
  BehaviorTeamMessage::DynamicRole role;

  /** computes the current role */
  void computeRole();

  //!@name Input symbols
  //!@{
  /* 
  * A function for the symbol "robot-number". 
  * Returns the robots back number as read from player.cfg 
  */
  double getRobotNumber() { return (double)(getPlayer().getPlayerNumber() + 1); };

  /*!< calculates the value for the input function get-angle-to-teammate with parameter index */
  double getAngleToTeammate();  
  /*!< the Parameter "robot-pose.get-angle-to-teammate.index" for the decimal input function "robot-pose.get-angle-to-teammate" */
  double angleToTeammateIndex; 

  /** A function for the symbol "another-player-is-in-ready-state". */
  bool getAnotherPlayerIsInReadyState();

  /** A function for the symbol "another-player-is-in-initial-state". */
  bool getAnotherPlayerIsInInitialState();

  /** A function for the symbol "another-teammate-is-performing-a-kick" */
  bool getAnotherTeammateIsPerformingAKick();

  /** A function for the symbol "the-striker-is-playing-near-the-opponent-goal" */
  bool getTheStrikerIsPlayingNearTheOpponentGoal();

  /** A function for the symbol "the-striker-is-not-playing-near-the-opponent-goal" */
  bool getTheStrikerIsNotPlayingNearTheOpponentGoal();

  /** A function for the symbol "the-striker-is-playing-near-the-own-goal" */
  bool getTheStrikerIsPlayingNearTheOwnGoal();

  /** A function for the symbol "the-striker-is-not-playing-near-the-own-goal" */
  bool getTheStrikerIsNotPlayingNearTheOwnGoal();

  /** A function for the symbol "goalie-max-position-speed" */
  double getGoalieMaxPositionSpeed(); 

  /** A function for the symbol "search-ball.x" */
  double getSearchBallX();

  //!@}

  /** Output-Symbols for Profiler */
  enum { doProfiling, dontDoProfiling} doProfile;
  enum { writeProfiles, writeCompleteProfiles, dontWriteProfiles} writeProfile;

};


#endif // __GT2004StrategySymbols_h_

/*
* Change Log
* 
* $Log: GT2004StrategySymbols.h,v $
* Revision 1.4  2004/06/18 11:11:26  risler
* kick team messages clean up
* intercept behavior improved
*
* Revision 1.3  2004/06/16 14:43:51  risler
* added obstacles symbols
* added symbol obstacles.opponent-close-to-ball
*
* Revision 1.2  2004/05/26 18:56:41  loetzsch
* clean up in the behavior control interfaces
*
* Revision 1.1.1.1  2004/05/22 17:18:04  cvsadm
* created new repository GT2004_WM
*
* Revision 1.2  2004/05/03 14:33:20  loetzsch
* some cleanup
*
* Revision 1.1  2004/05/02 13:23:46  juengel
* Added GT2004BehaviorControl.
*
*/

