/** 
* @file GT2004ConfigurationSymbols.h
*
* Declaration of class GT2004ConfigurationSymbols.
*
* @author Max Risler
*/

#ifndef __GT2004ConfigurationSymbols_h_
#define __GT2004ConfigurationSymbols_h_

#include "../../BehaviorControl.h"
#include "Tools/Xabsl2/Xabsl2Engine/Xabsl2Engine.h"

/**
* The Xabsl2 symbols that are defined in "configuration-symbols.xml"
*
* @author Max Risler
*/ 
class GT2004ConfigurationSymbols : public Xabsl2FunctionProvider, public BehaviorControlInterfaces
{
public:
/*
* Constructor.
* @param interfaces The parameters of the BehaviorControl module.
  */
  GT2004ConfigurationSymbols(BehaviorControlInterfaces& interfaces);
  
  /** registers the symbols at an engine */
  void registerSymbols(Xabsl2Engine& engine);

  /** updates the symbols */
  void update();

  //!@name Input symbols
  //!@{
  double getCurrentKickoff(); /*!< A function for the symbol "current-kickoff-variant" */
  double getOwnKickoffX(); /*!< A function for the symbol "own-kickoff.x" */
  double getOwnKickoffY(); /*!< A function for the symbol "own-kickoff.y" */
  double getOwnKickoffAngle(); /*!< A function for the symbol "own-kickoff.angle" */
  double getOwnKickoffXByObstacles(); /*!< A function for the symbol "own-kickoff.x" by obstacle model */
  double getOwnKickoffYByObstacles(); /*!< A function for the symbol "own-kickoff.y" by obstacle model */
  double getOwnKickoffAngleByObstacles(); /*!< A function for the symbol "own-kickoff.angle" by obstacle model */
  double getOpponentKickoffX(); /*!< A function for the symbol "opponent-kickoff.x" */
  double getOpponentKickoffY(); /*!< A function for the symbol "opponent-kickoff.y" */
  double getOpponentKickoffAngle(); /*!< A function for the symbol "opponent-kickoff.angle" */
  //!@}
private:

    /** number of different kickoff variants */
  enum { numOfKickoff = 2 };

  /** the max speed with which the robot walks to its kickoff position */
  double goToKickoffMaxSpeed;

  /** the goalie start position */
  Vector2<double> goalie;

  /** the defensive supporter start position */
  Vector2<double> defensiveSupporter;

  /** the offensive supporter start position at opponent kickoff */
  Vector2<double> offensiveSupporterOpponentKickoff;
  /** the striker start position at opponent kickoff */
  Vector2<double> strikerOpponentKickoff;

  /** the offensive supporter start position at own kickoff */
  Vector2<double> offensiveSupporterOwnKickoff[numOfKickoff];
  /** the orientation of the offensive supporter at own kickoff in degrees */
  double offensiveSupporterOwnKickoffAngle[numOfKickoff];
  /** the striker start position at own kickoff */
  Vector2<double> strikerOwnKickoff[numOfKickoff];
  /** the orientation of the striker at own kickoff in degrees */
  double strikerOwnKickoffAngle[numOfKickoff];

  /**
  * current own kickoff variant 
  */
  int currentKickoff;

  /** kickoff-position of striker based on obstacle-model */
  Pose2D obstacleKickoff;
};


#endif // __GT2004ConfigurationSymbols_h_

/*
* Change Log
* 
* $Log: GT2004ConfigurationSymbols.h,v $
* Revision 1.2  2004/07/02 16:52:55  thomas
* modified kickoff
* - striker positioning to angle based on obstacle-model
* - supporter not so near to side-border and a bit more away from middle-line
*
* Revision 1.1.1.1  2004/05/22 17:18:02  cvsadm
* created new repository GT2004_WM
*
* Revision 1.1  2004/05/02 13:23:45  juengel
* Added GT2004BehaviorControl.
*
*/

