/**
* @file GT2004ContinuousRules/TurnToAngle.h
*
* @author Max Risler
*/

#ifndef __GT2004TurnToAngle_h_
#define __GT2004TurnToAngle_h_

#include "Tools/ContinuousBasicBehaviors/ContinuousRule.h"

namespace GT2004ContinuousRules
{

/**@class TurnToAngle
 */
class TurnToAngle: public ContinuousRule{
private:
  /** reference to the angle to turn to */
  const double &angle;
  /** the angle is relative */
  bool relative;

public:

  /** constructor
   */
  TurnToAngle(
    BehaviorControlInterfaces& interfaces,
    const double &angle,
    bool relative = false)
    :
    ContinuousRule(interfaces,"TurnToAngle"),
    angle(angle),
    relative(relative)
  {};

  /**
   * Returns whether this rule generates absolute or robot relative coordinates.
   */
  virtual bool isRelative() {return relative;}

 	/** executes the basic behavior rule
   * @param robotPose the current robots pose at which the rule is to be evaluated
   * @param walk the direction and speed of the suggested motion coded as an vector (output)
	 * @param ra the rotation angle, the direction the robot should be directed (output)
	 * @param rweight the rotation weight the weight of the suggested rotation (output)
	 */
  virtual void execute(const RobotPose& robotPose,
                       Vector2<double>& walk,
                       double& ra, double& rweight)
  {

    walk.x = walk.y = 0;

    ra = fromDegrees(angle);
    rweight=1.0;
  }
};

}


#endif //__GT2004TurnToAngle_h_


/*
* Change log:
*
* $Log: TurnToAngle.h,v $
* Revision 1.1.1.1  2004/05/22 17:18:02  cvsadm
* created new repository GT2004_WM
*
* Revision 1.1  2004/05/02 13:19:03  juengel
* Added GT2004BehaviorControl.
*
*/
